<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Displays help via AJAX call or in a new page
 *
 * Use {@link core_renderer::help_icon()} or {@link addHelpButton()} to display
 * the help icon.
 *
 * @copyright 2002 onwards Martin Dougiamas
 * @package   core
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
namespace local_m1m2;
defined('MOODLE_INTERNAL') || die();
require_once($CFG->dirroot.'/local/m1m2/config.php');
require_login();
class observers {
    public static function create_user(\core\event\user_created $event) {
        GLOBAL $dbconn,$DB;
        if ($DB->record_exists('local_m1m2',array())) {
            $localdb = $DB->get_record('local_m1m2',array());
        }
        $table = $localdb->prefix."user";
        // Add your custom code here.
        if ($event) {
            $events = $event->get_record_snapshot('user', $event->objectid);
            $sql = "INSERT INTO $table ( auth, confirmed,policyagreed,deleted,suspended,
            mnethostid,username,password,idnumber,firstname,lastname,email,emailstop,phone1,phone2,
            institution,department,address,city,country,lang,calendartype,theme,timezone,firstaccess,
            lastaccess,lastlogin,currentlogin,lastip,secret,picture,description,descriptionformat,mailformat,
            maildigest,maildisplay,autosubscribe,trackforums,timecreated,timemodified,trustbitmask,imagealt,
            lastnamephonetic,firstnamephonetic,middlename,alternatename,moodlenetprofile)
            VALUES ('$events->auth','$events->confirmed','$events->policyagreed','$events->deleted',
            '$events->suspended','$events->mnethostid','$events->username','$events->password','$events->idnumber',
            '$events->firstname','$events->lastname','$events->email','$events->emailstop','$events->phone1',
            '$events->phone2','$events->institution','$events->department','$events->address','$events->city',
            '$events->country','$events->lang','$events->calendartype','$events->theme','$events->timezone',
            '$events->firstaccess','$events->lastaccess','$events->lastlogin','$events->currentlogin',
            '$events->lastip','$events->secret','$events->picture','$events->description','$events->descriptionformat',
            '$events->mailformat','$events->maildigest','$events->maildisplay','$events->autosubscribe',
            '$events->trackforums','$events->timecreated','$events->timemodified','$events->trustbitmask',
            '$events->imagealt','$events->lastnamephonetic','$events->firstnamephonetic','$events->middlename',
            '$events->alternatename','$events->moodlenetprofile')";
            $dbconn->exec($sql);
        }
    }
    public static function delete_user(\core\event\user_deleted $event) {
        GLOBAL $dbconn,$DB;
        if ($DB->record_exists('local_m1m2',array())) {
            $localdb = $DB->get_record('local_m1m2',array());
        }
        $table = $localdb->prefix."user";
            // Add your custom code here.
            $events = $event->get_record_snapshot('user', $event->objectid);
            $sql = "UPDATE $table SET deleted=1 WHERE email='$events->email'";
            $dbconn->exec($sql);
    }
    public static function update_user(\core\event\user_updated $event) {
        // Add your custom code here.
        GLOBAL $dbconn,$DB;
        if ($DB->record_exists('local_m1m2',array())) {
            $localdb = $DB->get_record('local_m1m2',array());
        }
        $table = $localdb->prefix."user";
        if ($event) {
            $events = $event->get_record_snapshot('user', $event->objectid);
            $sql = "UPDATE $table SET  auth='$events->auth', confirmed='$events->confirmed',
            policyagreed='$events->policyagreed',deleted='$events->deleted',suspended='$events->suspended',
            mnethostid='$events->mnethostid',username='$events->username',password='$events->password',
            idnumber='$events->idnumber',firstname='$events->firstname',lastname='$events->lastname',
            email='$events->email',emailstop='$events->emailstop',phone1='$events->phone1',phone2='$events->phone1',
            institution='$events->institution',department='$events->department',address='$events->address',
            city='$events->city',country='$events->country',lang='$events->lang',calendartype='$events->calendartype',
            theme='$events->theme',timezone='$events->timezone',firstaccess='$events->firstaccess',lastaccess='$events->lastaccess',
            lastlogin='$events->lastlogin',currentlogin='$events->currentlogin',lastip='$events->lastip',
            secret='$events->secret',picture='$events->picture',description='$events->description',
            descriptionformat='$events->descriptionformat',mailformat='$events->mailformat',maildigest='$events->maildigest',
            maildisplay='$events->maildigest',autosubscribe='$events->autosubscribe',trackforums='$events->trackforums',
            timecreated='$events->timecreated',timemodified='$events->timemodified',trustbitmask='$events->trustbitmask',
            imagealt='$events->imagealt',lastnamephonetic='$events->lastnamephonetic',
            firstnamephonetic='$events->firstnamephonetic',middlename='$events->middlename',
            alternatename='$events->alternatename',moodlenetprofile='$events->moodlenetprofile' WHERE email='$events->email'";
            $dbconn->exec($sql);
        }
    }
}
