<?php
// require_once('../../config.php'); // Moodle configuration file
require_once($CFG->libdir. '/filelib.php');

function local_landing_page_extend_navigation(global_navigation $navigation)
{
    global $CFG, $PAGE;

    $icon = new pix_icon('key', '', 'local_landing_page', array('class' => 'icon pluginicon', 'style' => 'width: 22px; height: 30px; object-fit: contain;'));

    $navigation->add(
        "Course Banner",
        new moodle_url($CFG->wwwroot . '/local/landing_page/banner.php'),
        navigation_node::TYPE_CUSTOM,
        null,
        'local_landing_page',
        null
    )->showinflatnavigation = true;
}

function get_category_image_url($category_id) {

    global $DB, $CFG;

    // Check if the category exists
    if ($category = $DB->get_record('course_categories', ['id' => $category_id])) {
        $context = context_coursecat::instance($category->id);
        if (!isset($category->descriptionformat)) {
            $descriptionformat = FORMAT_MOODLE;
        } else {
            $descriptionformat = $category->descriptionformat;
        }
        $options === null;
       
        $text = file_rewrite_pluginfile_urls($category->description,
        'pluginfile.php', $context->id, 'coursecat', 'description', null);
            return format_text($text, $descriptionformat, $options);
        // Check if the category has an image associated with it
    
    }

    // Return a default image URL or handle the case when no image is found.
    // You can customize this part based on your requirements.
    // return $CFG->wwwroot . '/theme/image.php/your_theme_name/categorydefault';
}
?>