<?php
/**
 * Upgrade script for the course_price and course_banner tables.
 *
 * @package    local_landing_page
 * @subpackage upgrade
 * @license    https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

/**
 * Execute the upgrade process for the plugin.
 *
 * @param int $oldversion The version number of the currently installed plugin.
 * @return bool Indicates success or failure of the upgrade process.
 */
function xmldb_local_landing_page_upgrade($oldversion) {
    global $DB;

    $dbman = $DB->get_manager();

    $result = true;

    // Switch based on the old version to determine upgrade steps
    if ($oldversion < 2023052703) {
            $table = new xmldb_table('course_price');
            $table->add_field('id', XMLDB_TYPE_INTEGER, '10', null, XMLDB_NOTNULL, XMLDB_SEQUENCE, null);
            $table->add_field('courseid', XMLDB_TYPE_INTEGER, '11', null, XMLDB_NOTNULL, null, null);
            $table->add_field('price', XMLDB_TYPE_INTEGER, '11', null, XMLDB_NOTNULL, null, null);
            $table->add_field('timemodified', XMLDB_TYPE_INTEGER, '20', null, XMLDB_NOTNULL, null, null);
            $table->add_key('primary', XMLDB_KEY_PRIMARY, ['id']);
            if (!$dbman->table_exists($table)) {
                $dbman->create_table($table);
            }

            $table = new xmldb_table('course_banner');
            $table->add_field('id', XMLDB_TYPE_INTEGER, '10', null, XMLDB_NOTNULL, XMLDB_SEQUENCE, null);
            $table->add_field('courseid', XMLDB_TYPE_INTEGER, '11', null, XMLDB_NOTNULL, null, null);
            $table->add_field('image', XMLDB_TYPE_TEXT, null, null, XMLDB_NOTNULL, null, null);
            $table->add_field('timemodified', XMLDB_TYPE_INTEGER, '20', null, XMLDB_NOTNULL, null, null);
            $table->add_key('primary', XMLDB_KEY_PRIMARY, ['id']);
            if (!$dbman->table_exists($table)) {
                $dbman->create_table($table);
            }

            // Update the version number and exit
            upgrade_plugin_savepoint(true, '2023052703', 'local', 'landing_page');

        
    }

    return $result;
}
