<?php

require_once("../../config.php");

global $DB, $CFG;

require("$CFG->dirroot/enrol/externallib.php");

$id = required_param('id', PARAM_INT);

$course = $DB->get_record('course', ['id' => $id]);

$course_data = [];

// Category
$category = $DB->get_record_sql("SELECT mcc.name FROM {course_categories} mcc JOIN {course} mc ON mcc.id = mc.category WHERE mc.id = $id");

// Student Count
$studentRole = $DB->get_record('role', ['shortname' => 'student']);
$teacherRole = $DB->get_record('role', ['shortname' => 'coursecreator']);
$noneditingteacherRole = $DB->get_record('role', ['shortname' => 'manager']);
$context = context_course::instance($course->id);
$students = get_role_users($studentRole->id, $context, false, 'u.id, u.username, u.firstname, u.lastname, u.email', null, false);
$teacher = reset(get_role_users($teacherRole->id, $context, false, 'u.id, u.username, u.firstname, u.lastname, u.email, u.picture, u.description', null, false));

if(!$teacher){
    $teacher = reset(get_role_users($noneditingteacherRole->id, $context, false, 'u.id, u.username, u.firstname, u.lastname, u.email, u.picture, u.description', null, false));
}

// Course Creator name
$course_creator = $DB->get_record_sql("SELECT CONCAT(mu.firstname, ' ', mu.lastname) as name FROM {user} mu JOIN {logstore_standard_log} mlsl ON mu.id = mlsl.userid WHERE mlsl.courseid = $id AND mlsl.action = 'created' AND mlsl.target = 'course' AND mlsl.objecttable = 'course'");

// No. of days of course
$startdate = new DateTime(date("d-m-Y", $course->startdate));
$enddate = new DateTime(date("d-m-Y", $course->enddate));
$days = $startdate->diff($enddate)->days;

// Quiz Count
$quiz_count = count($DB->get_records_sql("SELECT mcm.id FROM {course_modules} mcm JOIN {modules} mm ON mcm.module = mm.id WHERE mcm.course = $id AND mm.name = 'quiz'"));

// Assignment Count
$assign_count = count($DB->get_records_sql("SELECT mcm.id FROM {course_modules} mcm JOIN {modules} mm ON mcm.module = mm.id WHERE mcm.course = $id AND mm.name = 'assign'"));

// Section Details
$section = [];
$course_sections = $DB->get_records_sql("SELECT mcs.* FROM {course_sections} mcs WHERE mcs.course = $id AND name != ''");

$section_count = count($course_sections);       // Section Count

foreach ($course_sections as $cs) {
    $data = new stdClass();;
    $data->name = $cs->name;
    $data->intro = $cs->summary;
    $data->quizes = count($DB->get_records_sql("SELECT mcm.id FROM {course_modules} mcm JOIN {modules} mm ON mcm.module = mm.id WHERE mcm.section = $cs->id AND mm.name = 'quiz'"));       // Quiz in section count
    $data->assigns = count($DB->get_records_sql("SELECT mcm.id FROM {course_modules} mcm JOIN {modules} mm ON mcm.module = mm.id WHERE mcm.section = $cs->id AND mm.name = 'assign'"));        // Assignment in section count
    $data->videos = count($DB->get_records_sql("SELECT mf.* FROM {files} mf JOIN {context} mc ON mf.contextid = mc.id JOIN {course_modules} mcm ON mc.instanceid  = mcm.id WHERE mf.component = 'mod_label' AND mf.filearea = 'intro' AND mf.mimetype LIKE 'video%' AND mc.contextlevel = 70 AND mcm.module = 14 AND mcm.section = $cs->id"));

    $section[] = ['section' => $data];
}

// Video Count
$videos_count = count($DB->get_records_sql("SELECT mf.* FROM {files} mf JOIN {context} mc ON mf.contextid = mc.id JOIN {course_modules} mcm ON mc.instanceid  = mcm.id WHERE mf.component = 'mod_label' AND mf.filearea = 'intro' AND mf.mimetype LIKE 'video%' AND mc.contextlevel = 70 AND mcm.module = 14 AND mcm.course = $id"));

// Course Image
$context = context_course::instance($course->id);
$course_img =   \core_course\external\course_summary_exporter::get_course_image($course);

// Teacher Info
$teacher_data = [];
if ($teacher) {
    $context = context_user::instance($teacher->id);
    $file_path = $teacher->picture;
    $teacher_image = moodle_url::make_pluginfile_url(
        $context->id,
        'user',
        'icon',
        null,
        '/',
        $file_path
    );
    $teacher_data['teacher_name'] = "$teacher->firstname $teacher->lastname";
    $teacher_data['teacher_image'] = $teacher_image;
    $teach_courses = $DB->get_records_sql("SELECT mc.id FROM {course} mc JOIN {enrol} me ON mc.id = me.courseid JOIN {user_enrolments} mue ON mue.enrolid = me.id WHERE mue.userid = $teacher->id");
    $student_handled = 0;
    foreach ($teach_courses as $tc) {
        $context = context_course::instance($tc->id);
        $student_handled += count(get_role_users($studentRole->id, $context, false, 'u.id, u.username, u.firstname, u.lastname, u.email', null, false));
    }
    $teacher_data['teacher_courses'] = count($teach_courses);       // Teacher Courses Count
    $teacher_data['student_handled'] = $student_handled;       // Total Students Count taught by this teacher
    $teacher_data['description'] = $teacher->description;
}

// Other Courses
$other_courses = $DB->get_records_sql("SELECT * FROM {course} WHERE id NOT IN (1, $id) LIMIT 3");
$other_arr = [];
foreach ($other_courses as $oc) {
    $obj = new stdClass();
    $obj->courseid = $oc->id;
    $obj->coursename = $oc->fullname;
    $obj->shortname = $oc->shortname;
    $context = context_course::instance($oc->id);
    $obj->courseimg =   \core_course\external\course_summary_exporter::get_course_image($oc);
    $teacher = reset(get_role_users($teacherRole->id, $context, false, 'u.id, u.username, u.firstname, u.lastname, u.email, u.picture, u.description', null, false));
    if(!$teacher){
        $teacher = reset(get_role_users($noneditingteacherRole->id, $context, false, 'u.id, u.username, u.firstname, u.lastname, u.email, u.picture, u.description', null, false));
    }
    $obj->teacher = "$teacher->firstname $teacher->lastname";
    $occourse_price = $DB->get_record_sql("Select cost FROM {enrol} Where enrol = 'paypal' AND courseid = $oc->id")->cost;
    $obj->courseprice = $occourse_price;
    $other_arr[] = $obj;
}
$course_price = $DB->get_record_sql("Select cost FROM {enrol} Where enrol = 'paypal' AND courseid = $course->id")->cost;

$description2 = $DB->get_record_sql("Select cd.value FROM {customfield_data} cd JOIN {customfield_field} cf ON cd.fieldid =cf.id Where cf.shortname ='course_description' and cd.instanceid = $course->id")->value;

$language = "English";

$course_data['category'] = $category->name;
$course_data['shortname'] = $course->shortname;
$course_data['fullname'] = $course->fullname;
$course_data['summary'] = $course->summary;
$course_data['summary2'] = $description2;
$course_data['courseobjective'] = $course->courseobjective;
$course_data['aboutcourse'] = $course->aboutcourse;
$course_data['studentcount'] = count($students);
$course_data['course_creator'] = $course_creator->name;
$course_data['lastupdated'] = date("d/m/Y", $course->timemodified);
$course_data['language'] = $language;
$course_data['course_objectives'] = $course->courseobjective;
$course_data['days'] = $days;
$course_data['quiz_count'] = $quiz_count;
$course_data['assign_count'] = $assign_count;
$course_data['section_count'] = $section_count;
$course_data['course_img'] = $course_img;
$course_data['teacher_data'] = $teacher_data;
$course_data['sections'] = $section;
$course_data['videos_count'] = $videos_count;
$course_data['course_price'] = $course_price;
$course_data['courseurl'] = new moodle_url('/course/view.php', ['id' => $course->id]);
$course_data['courseimage'] = \core_course\external\course_summary_exporter::get_course_image($course);
$course_data['other_courses'] = $other_arr;
echo $OUTPUT->header();
$templateData = [
    'title' => $course->shortname,
    'course_data' => $course_data
];

echo $OUTPUT->render_from_template('local_landing_page/course', $templateData);
echo $OUTPUT->footer();