<?php
require_once("../../config.php");
require_once(dirname(__FILE__) . '/classes/forms/banner.php');

$PAGE->set_heading('Course Banner');
$PAGE->set_title('Course Banner');


$form = new banner();
if ($form->is_cancelled()) {
    redirect($CFG->wwwroot . '/local/landing_page/banner.php');
} else if ($formdata = $form->get_data()) {
    $fs = get_file_storage();
    $context = context_course::instance($formdata->course);
    $filename = time() . $form->get_new_filename('image');
    $success = $form->save_file('image', "$CFG->dirroot/local/landing_page/banners/$filename", true);
    if ($success) {
        $record = new stdClass();
        $record->courseid = $formdata->course;
        $record->userid = $USER->id;
        $record->image = $filename;
        $record->timemodified = time();
        if(!$banner = $DB->get_record('course_banner', ['courseid' => $formdata->course])){
            $DB->insert_record('course_banner', $record);
        } else {
            $record->id = $banner->id;
            $DB->update_record('course_banner', $record);
        }
        redirect($CFG->wwwroot . '/local/landing_page/banner.php', 'Banner Uploaded Successfully');
    } else {
        redirect($CFG->wwwroot . '/local/landing_page/banner.php', 'Something Went Wrong. Please Try Again!');
    }
} else {
    echo $OUTPUT->header();
    echo $form->display();
    echo $OUTPUT->footer();
}
