<?php
require_once('../../config.php');
global $DB, $OUTPUT, $PAGE, $USER;
require_login();

// if (!user_has_role_assignment($USER->id, 5)) {
// throw new moodle_exception('you dont have permission to access this page','core');
// }

$PAGE->set_title('View All Tracks');
$PAGE->set_heading('View All Tracks');
$PAGE->set_pagelayout('standard');
$PAGE->navbar->add('View All Tracks',new moodle_url(''));
$PAGE->requires->css('/local/public/css/view_alltracks.css');
$PAGE->requires->js('/local/public/amd/src/view_alltrack.js');

echo $OUTPUT->header();
$i = 0;
$y = 0;
$unique_track_ids = [];
$array = [];

$user_enrol_courses = enrol_get_users_courses($USER->id, $onlyactive = false, $fields = null, $sort = null);  // get all courses in which user enrol
foreach ($user_enrol_courses as $user_enrol_coursesss) {
  $array[] =  $user_enrol_coursesss->category;
}

$array = array_unique($array); //generate unique courses
$array = array_values($array); //generate unique courses
$student_enrolled_courses = implode(",", $array);

$student_enrolled_courses = trim($student_enrolled_courses, '"');

for ($i = 0; $i <= count($array); $i++) {
  $enrol_courses = $DB->get_records_sql(" SELECT * FROM {course_categories} WHERE id ='$array[$i]' AND parent != 0 ");

  foreach ($enrol_courses as $enrol_courses1) {
    $enrol_courses2 = $DB->get_records_sql("SELECT * FROM {course_categories} WHERE id =$enrol_courses1->parent AND parent = 0");
    foreach ($enrol_courses2 as $enrol_tracks) {
      $unique_track_ids[] = $enrol_tracks->id;
    }
  }
}

$unique_track_ids = array_unique($unique_track_ids); 
$unique_track_ids = array_values($unique_track_ids); 

for ($y = 0; $y <= count($unique_track_ids); $y++) {

  if ($DB->record_exists('course_categories', ['id' => $unique_track_ids[$y], 'visible' => 1])) {
      $course_completed = 0;
      $total_enrolled_courses = $DB->get_records_sql("SELECT * FROM {course_categories} WHERE id IN ($student_enrolled_courses) AND parent = $unique_track_ids[$y]  AND visible = 1");
      if ($total_enrolled_courses) {

      $enrol_track_names = $DB->get_record('course_categories', ['id' => $unique_track_ids[$y]]);
      
      $total_completed_activity1 = [];
      $total_activities = 0;
      $percentage_of_completion = 0;
      for ($i = 0; $i <= count($array); $i++) {

          $enrol_courses = $DB->get_record_sql(" SELECT * FROM {course_categories} WHERE id = '$array[$i]' AND parent = $enrol_track_names->id");
          if ($enrol_courses) {
              $modules_in_course = 0;
              $completed_moduleincourse = 0;
              $module_record = $DB->get_records('course', ['category' => $enrol_courses->id]);
              foreach ($module_record as $module_record1) {

                  $context = context_course::instance($module_record1->id);

                  if (is_enrolled($context, $USER->id, '', true)) {
                      $module_object = $DB->get_record('course', ['id' => $module_record1->id]);

                      $check = core_completion\progress::get_course_progress_percentage($module_object, $USER->id);
                      if ($check == 100) {
                          $completed_moduleincourse++;
                      }
                      $module_activityid = $DB->get_records_sql("SELECT * FROM {course_modules} WHERE course = $module_record1->id AND module != 10 AND deletioninprogress = 0");

                      $total_activities = count($module_activityid) + $total_activities;
                      foreach ($module_activityid as $module_activityid1) {
                          $completed_activity = $DB->get_record_sql("SELECT * FROM {course_modules_completion} WHERE userid = $USER->id AND  completionstate = 1 AND coursemoduleid = $module_activityid1->id");

                          // foreach($completed_activity as $completed_activity1){
                          if ($completed_activity->id) {
                              $total_completed_activity1[] = $completed_activity->id;
                          }
                          // }
                      }
                      $modules_in_course++;
                  }
              }
              if ($modules_in_course == $completed_moduleincourse) {
                  $course_completed++;
              }
          }
      }

      $percentage_of_completion = (count($total_completed_activity1) / $total_activities) * 100;

      if (is_nan($percentage_of_completion)) {
          $percentage_of_completion = 0;
      }


    $track_detail[] = [
      'trackname'=>$enrol_track_names->name,
      'completion'=>round($percentage_of_completion),
      'totalcourse'=>count($total_enrolled_courses),
      'completedcourse'=>$course_completed,
      'trackid'=>$enrol_track_names->id

    ];
  }
}
}

$data = [
'trackdata'=>$track_detail

];
echo $OUTPUT->render_from_template('local_public/view_alltrack',$data);
echo $OUTPUT->footer();
