<?php
require_once('../../config.php');
require_once(__DIR__ . '/lib.php');
require_once($CFG->dirroot . '/course/lib.php');
require_once($CFG->dirroot . '/calendar/lib.php');

require_login();
// $view = optional_param('view', 'upcoming', PARAM_ALPHA);


global $CFG, $USER, $PAGE, $view;
$PAGE->set_context(context_system::instance());
$PAGE->set_url($CFG->wwwroot . '/local/public/dashboard.php');
$PAGE->set_title('Admin Dashboard');
$PAGE->set_pagelayout('standard');
$PAGE->requires->css('/local/public/css/dashboard.css');
$PAGE->requires->css('/local/public/css/bootstrap.min.css');
$PAGE->requires->css('/local/public/css/font-awesome.min.css');
$PAGE->requires->css('/local/public/css/style.css');
$PAGE->requires->css('/local/public/bootstrap/bootstrap-multiselect.css');
$PAGE->requires->css('/local/public/css/datepicker.min.css');
$PAGE->requires->js('/local/public/amd/src/dashboard.js');
$PAGE->requires->js('/local/public/amd/src/bootstrap.min.js');
$PAGE->requires->js('/local/public/amd/src/bootstrap-multiselect.js');

$instructor_roleid = $DB->get_field('role', 'id', ['shortname' => 'manager']);
if (!is_siteadmin()) {
   if (!user_has_role_assignment($USER->id, $instructor_roleid)) {

      // throw new moodle_exception("you dont have permission to access this page", "core");
      redirect($CFG->wwwroot . '/my/');
   } else {
      redirect($CFG->wwwroot . '/my/');
   }
}

// ******* code for browser name *********
purge_caches();
$table = 'logstore_standard_log';
$lastlogin_record = $DB->get_record_sql("SELECT lsl.* FROM {logstore_standard_log} lsl WHERE lsl.userid = $USER->id AND lsl.action = 'loggedin' ORDER BY lsl.id DESC LIMIT 1");
if (!$lastlogin_record->browswername) {
   $dataobject = new stdClass();
   $dataobject->id = $lastlogin_record->id;
   $dataobject->browsername = get_browser_name($_SERVER['HTTP_USER_AGENT']);
   $namebrowser =  get_browser_name($_SERVER['HTTP_USER_AGENT']);

   $updated = $DB->execute("UPDATE {logstore_standard_log} SET browsername = '$namebrowser' WHERE id = $lastlogin_record->id");
}
// ******* end code for browser name *********

// ******* code for inacive and active user
$users = $DB->get_records('user', ['deleted' => 0]);
// $activeuser = $DB->get_records('user_online', array());
$activeuser = $DB->get_records_sql("SELECT u.* FROM {user_online} u JOIN {user} us ON us.id = u.userid WHERE us.deleted = 0");
$total_user = count($users);
$active_user = count($activeuser);
$inactive_user = $total_user - $active_user;
// ******* end code for inacive and active user

// ******* code for stay toggle theme change color .
$color = $DB->get_record('navbar_color', ['userid' => $USER->id]);
if (!$color->color_mode) {
   $addclass = "fa-toggle-on";
} else {
   $addclass = "";
}

// ******* end code for stay toggle theme change color 
$toptracks = $DB->get_records('course_categories', ['parent' => 0, 'visible' => 1], $sort = '', $fields = '*', $limitfrom = 0, $limitnum = 5);
$alltracks = $DB->get_records('course_categories', ['parent' => 0, 'visible' => 1], $sort = '', $fields = '*', $limitfrom = 0, $limitnum = 0);
$colorarray = ['#43C822', '#D93333', '#004CFD', '#EF9001', '#05E0FF'];
$recent_badge_assigned = $DB->get_records_sql("SELECT * FROM {assign_badge} bi  ORDER BY bi.id DESC LIMIT 5");
// $recent_certificate_assigned = $DB->get_records_sql("SELECT * FROM {assign_certificate} bi  ORDER BY bi.id DESC LIMIT 2");
$notepaddata = $DB->get_records_sql("SELECT * FROM {notepad} WHERE userid = $USER->id  ORDER BY id DESC LIMIT 2");
$accessdata = $DB->get_records_sql("SELECT lsl.* FROM {logstore_standard_log} lsl WHERE lsl.userid = $USER->id AND lsl.action = 'loggedin' ORDER BY lsl.id DESC LIMIT 4");
$draftmodules = $DB->get_records('course');
$draftedcourses = $DB->get_records_sql("SELECT cc.*,u.username FROM {course_categories} cc JOIN {request_subcategory} rs ON rs.subcategory_id = cc.id JOIN {user} u ON u.id = rs.userid WHERE cc.visible = 0 AND rs.status = 0 OR rs.status = 4 ORDER BY cc.id DESC LIMIT 5 ");


?>
<!DOCTYPE html>
<html lang="en">

<head>
   <meta charset="UTF-8">
   <meta http-equiv="X-UA-Compatible" content="IE=edge">
   <meta name="viewport" content="width=device-width, initial-scale=1.0">
   <link rel="icon" href="<?php echo $CFG->wwwroot ?>/theme/classic/pix/favicon.ico">
   <title>Admin Dashboard</title>
</head>
<style>
   span.bulklogoutspan {
    display: flex;
    align-items: baseline;
    /* background: red; */
    column-gap: 19px;
    flex-direction: row;
    justify-content: center;
}
</style>
<body>
   <?php echo $OUTPUT->header(); ?>
   <!-- <input type="hidden" id="toggleclass" value="<?php echo $addclass; ?>"> -->


   <div class="dashboard-main">
      <div class="container-fluid p-0">
         <div class="row">

            <div class="col-12 col-md-12 col-lg-12">
               <div class="right-content">


                  <div class="latest-announcement bg-grey">
                     <div class="latest-announcement-content">
                        <h2>Latest Announcement</h2>
                     </div>
                     <div class="marque">
                        <marquee behavior="" direction="">
                           <div style="display: flex;">
                              <?php echo latest_announcement(); ?>
                           </div>

                        </marquee>
                     </div>
                  </div>
                  <section class="swift-management bg-grey-box">


                     <h2 class="horizontal-line">swift management</h2>
                     <div class="management-section">
                        <div class="management user-button">
                           <!-- <a href="http://"> -->
                           <div class="user-icon blue-bg"><img src="<?php echo $CFG->wwwroot . '/pix/UserManagement.svg' ?>" alt="UserManagement">
                           </div>
                           <div class="user-detail">
                              <a href="activeuser_table.php">
                                 <h2 class="swift-management-h2">Users
                                    <br>
                                    <span class="active-green-pin"><?php echo $active_user . "/" . $inactive_user; ?></span>
                                 </h2>
                              </a>
                           </div>

                        </div>
                        <!-- </a> -->

                        <div class="management Content-button">
                           <div class="user-icon grey-bg"><img src="<?php echo $CFG->wwwroot . '/pix/Create-Content.svg' ?>" alt="Create-Content"></div>
                           <div class="user-detail">
                              <a href="view-courses.php">
                                 <h2 class="swift-management-h2">Create
                                    <br>
                                    content
                                 </h2>
                              </a>
                           </div>
                        </div>

                        <div class="management Crisis-button">
                           <div class="user-icon purple-bg"><i class="fa fa-line-chart"></i></div>
                           <div class="user-detail">
                              <a href="#">
                                 <h2 class="swift-management-h2">Create
                                    <br>
                                    Crisis Exercise
                                 </h2>
                              </a>
                           </div>
                        </div>
                        <div class="management Simulation-button">
                           <div class="user-icon blue-bg-down"><img src="<?php echo $CFG->wwwroot . '/pix/Create-Content.svg'; ?>" alt="Create-Content"></div>
                           <div class="user-detail">
                              <a href="#">
                                 <h2 class="swift-management-h2">Create
                                    <br>
                                    scenario
                                 </h2>
                              </a>
                           </div>
                        </div>
                        <div class="management Announcement-Button">
                           <div class="user-icon blue-bg-dark"><img src="<?php echo $CFG->wwwroot . '/pix/Announcement.svg' ?>" alt="Announcement"></div>
                           <div class="user-detail">

                              <a href="announcement.php">
                                 <h2 class="swift-management-h2 announcement">Announcement</h2>
                              </a>
                           </div>
                        </div>
                     </div>
                  </section>
                  <section class="section-status">
                     <div class="d-flex gap-4">
                        <div class="chart-section bg-grey-box">
                           <div class="status">
                              <div class="status-info">
                                 <h2 class="horizontal-line line1">Cyber Exercise Status</h2>
                                 <span><a href="#"><i class="fa fa-share-square-o" title="view all"></i></a></span>
                              </div>
                              <!-- <ul>
                                 <li class="list">1</li>
                                 <li class="list">2</li>
                                 <li class="list">3</li>
                                 <li class="list">4</li>
                                 <li class="list">5</li>
                                 <li class="list">6</li>
                              </ul> -->
                           </div>
                        </div>


                        <div class="chart-section bg-grey-box">
                           <div class="status">
                              <div class="status-info pb-1">
                                 <h2 class="horizontal-line line2">Quick Analysis</h2>

                                 <span><a href="view_tracks.php?treset=1"><i class="fa fa-share-square-o" title="view all"></i></a></span>
                              </div>
                              <section class="chart">
                                 <canvas id="myChart" style="width:100%;max-width:13vw;"></canvas>

                                 <div class="track-table activity-overflow Quick-AnalysisQuick-Analysis">
                                    <select multiple="multiple" name="selecttrack" id="selecttrack" class="m-0" onchange="quickanalyis_record()">
                                       <div class="scrollit">
                                          <?php
                                          $z = 0;
                                          foreach ($alltracks as $alltracks_values) {

                                          ?>
                                             <option value="<?php echo $alltracks_values->id; ?>"><?php echo $alltracks_values->name; ?></option>

                                          <?php
                                             $z++;
                                          }
                                          ?>
                                       </div>
                                    </select>

                                    <div class="scrollit">
                                       <table>
                                          <thead>
                                             <tr>

                                                <th>
                                                   <!-- Tracks -->
                                                </th>
                                                <th>Courses</th>
                                                <th>Users</th>

                                             </tr>
                                          </thead>
                                          <tbody id="quick_analysis">
                                             <?php
                                             $y = 0;
                                             foreach ($toptracks as $alltracks_values) {

                                                $countcourse = $DB->get_records('course_categories', ['parent' => $alltracks_values->id]);
                                                $userids = [];
                                                foreach ($countcourse as $courses1) {
                                                   $cat = core_course_category::get($courses1->id);
                                                   $moduleids = $cat->get_courses(['recursive', 'idonly']);
                                                   foreach ($moduleids as $moduleid) {
                                                      $context = context_course::instance($moduleid->id);
                                                      $moduleusers = get_enrolled_users($context, '', 0, 'u.id');
                                                      $userids = array_merge($userids, array_keys($moduleusers));
                                                   }
                                                }
                                                $count_of_category_enrolled_user = count($userids);
                                                $count_of_user[] = count($userids);
                                                $trackname[] = $alltracks_values->name;
                                                $noof_course[] = count($countcourse);

                                             ?>
                                                <tr>
                                                   <td class="chart-hover" style="color:<?php
                                                                                          echo $colorarray[$y];
                                                                                          ?>;" title="<?php
                                                                                                      echo $alltracks_values->name;
                                                                                                      ?>"><?php
                                                                                                            echo $alltracks_values->name;
                                                                                                            ?></td>
                                                   <!-- <td><?php

                                                            // echo $alltracks_values->name;
                                                            ?></td> -->

                                                   <td><?php echo count($countcourse); ?></td>
                                                   <td><?php echo $count_of_category_enrolled_user; ?></td>
                                                </tr>

                                             <?php

                                                $y++;
                                             }
                                             $string_trackname = implode(",", $trackname);
                                             $string_count_of_user = implode(",", $count_of_user);
                                             $string_colorlist = implode(",", $colorarray);
                                             $string_courselist = implode(",", $noof_course);


                                             ?>
                                             <input type="hidden" id="countlist" value="<?php echo $string_count_of_user; ?>" />
                                             <input type="hidden" id="tracklist" value="<?php echo $string_trackname; ?>" />
                                             <input type="hidden" id="colorlist" value="<?php echo $string_colorlist; ?>" />
                                             <input type="hidden" id="coursecount" value="<?php echo $string_courselist; ?>" />


                                          </tbody>
                                       </table>
                                    </div>
                                 </div>
                              </section>

                           </div>
                        </div>
                     </div>
                  </section>

                  <section class="course-main">
                     <div class="d-flex gap-4">
                        <div class="course-section bg-grey-box">
                           <div class="status">
                              <div class="status-info">
                                 <h2 class="horizontal-line line3">Course Request</h2>
                                 <span><a href="allcourse_request.php"><i class="fa fa-share-square-o" title="view all"></i></a></span>
                              </div>
                              <div class="scrollable course-section-scroll">
                                 <table>
                                    <tr>
                                       <th>ID</th>
                                       <th>Course Name</th>
                                       <th>Track</th>
                                       <th>Requested By</th>
                                       <th>Status</th>
                                       <th>Action</th>

                                    </tr>
                                    <?php
                                    $draftedcoursescount = 1;
                                    foreach ($draftedcourses as $course_value) {
                                       $trackname = $DB->get_record_sql("SELECT * FROM {course_categories} WHERE id = $course_value->parent AND parent = 0");
                                    ?>
                                       <tr id="<?php echo $course_value->id; ?>">
                                          <td><?php echo $draftedcoursescount; ?></td>
                                          <td><a href="courses.php?id=<?php echo $trackname->id; ?>"><?php echo $course_value->name; ?></a></td>
                                          <td><?php echo $trackname->name; ?></td>
                                          <td><?php echo $course_value->username; ?></td>
                                          <?php
                                          if ($DB->record_exists('request_subcategory', ['subcategory_id' => $course_value->id, 'status' => 4])) {
                                          ?>
                                             <td class="status-revised">Revised</td>
                                             <td>
                                                <select name="" id="" onchange="courseaction(this.value)">
                                                   <option value="">Revised</option>
                                                   <option value="reject+<?php echo $course_value->id; ?>">Reject</option>
                                                   <!-- <option value="" disabled>Revise</option> -->
                                                </select>
                                             </td>
                                             <?php
                                          }
                                          if ($DB->record_exists('request_subcategory', ['subcategory_id' => $course_value->id, 'status' => 0])) {  // check if teacher sent course to admin
                                             $status = '';
                                             $get_approved_modules = $DB->count_records_sql("SELECT COUNT(rc.id) FROM {reject_course} rc WHERE rc.course_id IN (SELECT id FROM {course} WHERE category = $course_value->id) AND rc.status = 4");
                                             $get_modules_in_course = $DB->count_records_sql("SELECT COUNT(c.id) FROM {course} c WHERE c.category = $course_value->id AND c.visible = 0");
                                             $get_rejected_modules = $DB->count_records_sql("SELECT COUNT(rc.id) FROM {reject_course} rc WHERE rc.course_id IN (SELECT id FROM {course} WHERE category = $course_value->id) AND rc.status = 0");

                                             if ($get_modules_in_course == $get_approved_modules) {
                                             ?>
                                                <td class="status-pending" id="pendingtd<?php echo  $course_value->id ?>">Requested</td>
                                                <td id="selecttd<?php echo $course_value->id; ?>">
                                                   <select name="" id="" onchange="courseaction(this.value)">
                                                      <option value="">Requested</option>
                                                      <option value="approve+<?php echo $course_value->id; ?>">Approve</option>
                                                   </select>
                                                </td>
                                             <?php

                                             } elseif ($get_rejected_modules == $get_modules_in_course) {
                                             ?>
                                                <td class="status-pending" id="pendingtd<?php echo  $course_value->id ?>">Requested</td>
                                                <td id="selecttd<?php echo $course_value->id; ?>">
                                                   <select name="" id="" onchange="courseaction(this.value)">
                                                      <option value="">Requested</option>
                                                      <option value="reject+<?php echo $course_value->id; ?>">Reject</option>
                                                   </select>
                                                </td>
                                                <?php
                                             } else {

                                                if ($DB->record_exists_sql("SELECT * FROM {reject_course} WHERE course_id IN (SELECT id FROM {course} WHERE category = $course_value->id) AND status IN (0,3)")) {
                                                ?>
                                                   <td class="status-pending" id="pendingtd<?php echo  $course_value->id ?>">Requested</td>
                                                   <td id="selecttd<?php echo $course_value->id; ?>">
                                                      <select name="" id="" onchange="courseaction(this.value)">
                                                         <option value="">Requested</option>
                                                         <option value="reject+<?php echo $course_value->id; ?>">Reject</option>
                                                         <option value="revise+<?php echo $course_value->id; ?>">Revise</option>
                                                      </select>
                                                   </td>
                                                <?php
                                                } else {
                                                ?>
                                                   <td class="status-pending" id="pendingtd<?php echo  $course_value->id ?>">Requested</td>
                                                   <td id="selecttd<?php echo $course_value->id; ?>">
                                                      <select name="" id="" onchange="courseaction(this.value)">
                                                         <option value="">Requested</option>
                                                         <option value="approve+<?php echo $course_value->id; ?>">Approve</option>
                                                         <option value="reject+<?php echo $course_value->id; ?>">Reject</option>
                                                         <option value="revise+<?php echo $course_value->id; ?>">Revise</option>
                                                      </select>
                                                   </td>
                                          <?php

                                                }
                                             }
                                          }
                                          ?>
                                       </tr>
                                    <?php
                                       $draftedcoursescount++;
                                    }
                                    ?>
                                 </table>
                              </div>

                           </div>
                        </div>

                     </div>
                  </section>

                  <section class="recent-activity">
                     <div class="d-flex gap-4">
                        <div class="recent-section bg-grey-box">
                           <div class="status">
                              <div class="status-info">
                                 <h2 class="horizontal-line line4">Notes</h2>
                                 <span><a href="all-notes-view.php"><i class="fa fa-share-square-o" title="view all"></i></a></span>
                              </div>
                              <textarea name="" id="" cols="67" rows="4" class="textarea py-2" placeholder="Enter Notes"></textarea>

                              <button class="save-node">Save Note</button>
                              <span id="empty_error" style="color:red;"></span>
                              <div class="scrollable nodes">
                                 <div class="textarea-content">
                                    <h3 class="notes horizontal-line all-notes">All Notes</h3>
                                    <div class="ps-2 newnotes">
                                       <?php $i = 1; ?>
                                       <?php
                                       foreach ($notepaddata as $notepadata) {
                                       ?>
                                          <p class="mb-3 d-flex  justify-content-start"><b><?php echo $i++ ?>. &nbsp;&nbsp;</b> <span><?php echo $notepadata->note; ?></span></p>
                                       <?php } ?>
                                    </div>
                                 </div>
                              </div>
                           </div>
                        </div>
                        <div class="recent-section bg-grey-box">
                           <div class="status">
                              <div class="status-info">
                                 <h2 class="horizontal-line line5">Recent Activity</h2>
                                 <span><a href="allrecent_activity.php"><i class="fa fa-share-square-o" title="view all"></i></a></span>
                              </div>
                              <div class="activity-overflow">
                                 <?php
                                 foreach ($recent_badge_assigned as $recent_badge_assigned1) {
                                    if ($recent_badge_assigned1->type) {
                                       if ($recent_badge_assigned1->type == 'track') {
                                          $categorytype = 'Certificate';
                                       } else {

                                          $categorytype = 'Badge';
                                       }

                                 ?>
                                       <div class="activity">
                                          <div class="activity-icon"><i class="fa fa-user-o"></i></div>
                                          <div class="activity-detail">
                                             <p><?php echo $recent_badge_assigned1->student_firstname; ?> win <?php echo $categorytype . " in " . $recent_badge_assigned1->course_name; ?></p>

                                             <span class="span"><?php echo date('d-m-Y h:i:s a', $recent_badge_assigned1->timecreated); ?></span>
                                          </div>
                                       </div>
                                 <?php
                                    }
                                 }
                                 ?>

                                 <?php
                                 // foreach ($recent_certificate_assigned as $recent_certificate_assigned1) {
                                 ?>
                                 <!-- <div class="activity">
                                       <div class="activity-icon"><i class="fa fa-trash"></i></div>
                                       <div class="activity-detail">
                                          <p><?php
                                             //  echo $recent_certificate_assigned1->student_firstname;
                                             ?> win certificate in <?php
                                                                     //   echo $recent_certificate_assigned1->track_name; 
                                                                     ?></p>
                                          <span class="span"><?php
                                                               //  echo date('d-m-Y h:i:s a', $recent_certificate_assigned1->timecreated);
                                                               ?></span>

                                       </div>
                                    </div> -->
                                 <?php
                                 // }
                                 ?>



                              </div>
                           </div>
                        </div>
                     </div>
                  </section>
                  <section>
                     <div class="calendar-icon">
                        <a href="javascript:void(0);">
                           <i class="fa fa-calendar" aria-hidden="true"></i>
                        </a>
                     </div>
                  </section>
                  <section class="login Activity bg-grey-box">
                     <div class="status">
                        <div class="status-info">
                           <h2 class="horizontal-line line6">Login Activity</h2>
                           <div class="d-flex">
                              <span>
                                 

                                 <!-- <div class="dropdown">
                                    <a class="p-0 m-0" type="button" data-toggle="dropdown" aria-expanded="false">
                                       <img src="../../pix/i/prgress-icon.png" alt="" class="prgress-icon">
                                    </a>
                                    <ul class="dropdown-menu dropdown-menu-right p-0 m-0">
                                       <li><a class="dropdown-item" href="#">Active</a></li>
                                       <div class="dropdown-divider m-0"></div>
                                       <li><a class="dropdown-item" href="#">InActive</a></li>
                                    </ul>
                                 </div> -->
                              </span>
                              <span class="bulklogoutspan" >
                              <button class="btn btn-primary" id="bulklogout">Bulk Logout</button>
                              <a href="alllogin_activity.php"><i class="fa fa-share-square-o" title="view all"></i></a></span>
                           </div>
                        </div>
                        <div class="scrollable activity-table">
                           <table>
                              <tr>
                                 <th>
                                    <!-- <input type="checkbox" id="html5">
                                    <label for="html5"></label> -->
                                    <input type="checkbox" disabled value=''>
                                 </th>
                                 <th class="text-center">No</th>
                                 <th class="text-center">Date | Time</th>
                                 <th class="text-center">Location</th>
                                 <th class="text-center">IP Address</th>
                                 <th class="text-center">User Agent</th>
                                 <th class="text-center">Status</th>
                                 <th class="text-center">Action</th>
                              </tr>
                              <?php
                              $rowcount = 1;
                              foreach ($accessdata as $accessdata_value) {



                                 $user_ip = $accessdata_value->ip;
                                 $json     = file_get_contents("http://ipinfo.io/$user_ip/geo");
                                 $json     = json_decode($json, true);
                                 $city     = $json['city'];
                                 if ($accessdata_value->browsername == "Chrome") {
                                    $filename = "chrome";
                                 }
                                 if ($accessdata_value->browsername == "Firefox") {
                                    $filename = "firefox";
                                 }
                                 if ($accessdata_value->browsername == "Edge") {
                                    $filename = "microsoft";
                                 }
                                 if ($accessdata_value->browsername == "Compass") {
                                    $filename = "compass";
                                 }

                                 if ($DB->record_exists('sessions', ['userid' => $USER->id, 'timecreated' => $accessdata_value->timecreated, 'firstip' => $accessdata_value->ip])) {
                                    $disable = '';
                                    $checkboxvalue =  $accessdata_value->timecreated."_".$accessdata_value->ip;
                                 }
                                 else {
                                    $disable = 'disabled';
                                    $checkboxvalue =  '';

                                 }

                              ?>
                                 <tr>
                                    <td>

                                       <input type="checkbox" class= 'checkbox' <?= $disable ?> value="<?= $checkboxvalue ?>">

                                    </td>
                                    <td><?php echo ($rowcount); ?></td>
                                    <td><?php echo date('d-m-Y | h:i:s A', $accessdata_value->timecreated); ?></td>
                                    <td><?php echo $city; ?></td>
                                    <td><?php echo $user_ip; ?></td>
                                    <?php
                                    if ($accessdata_value->browsername) { ?>
                                       <td>
                                          <div class="fflx">
                                             <img src="images/<?php echo $filename; ?>.png" alt="chrome">
                                             <!-- <p><?php echo $accessdata_value->browsername; ?></p> -->
                                          </div>
                                       </td>

                                    <?php
                                    } else { ?>
                                       <td></td>
                                    <?php

                                    }
                                    ?>
                                    <?php
                                    if ($DB->record_exists('sessions', ['userid' => $USER->id, 'timecreated' => $accessdata_value->timecreated, 'firstip' => $accessdata_value->ip])) {
                                    ?> <td>
                                          <div class="active-green">Active</div>
                                       </td>

                                       <td>
                                          <span onClick="javascript:return confirm('are you sure you want to delete this session?');">

                                             <a href="<?php echo $CFG->wwwroot . '/local/public/delete_session.php?timecreated=' . $accessdata_value->timecreated . '&ip=' . $accessdata_value->ip . '' ?>">
                                                <i class="fa fa-power-off" aria-hidden="true">
                                                </i>
                                             </a>
                                          </span>
                                       </td>
                                    <?php  } else { ?>
                                       <td>
                                          <div class="active-cream">Inactive</div>
                                       </td>
                                       <td>
                                          <span>

                                             <a href="" style="pointer-events:none">
                                                <i class="fa fa-power-off" aria-hidden="true">
                                                </i>
                                             </a>
                                          </span>
                                       </td>
                                    <?php   }
                                    ?>


                                 </tr>
                              <?php

                                 // }
                                 $rowcount++;
                              }
                              ?>

                           </table>
                        </div>

                     </div>

                  </section>


                  <section class="course-main" id="Lab-Scenario-request">


                     <div class="d-flex gap-4">
                        <div class="lab-section bg-grey-box">
                           <div class="status">
                              <div class="status-info">
                                 <h2 class="horizontal-line labafterw">Lab/Scenario request</h2>
                                 <span><a href="#"><i class="fa fa-share-square-o" title="view all"></i></a></span>
                              </div>
                           </div>
                           <div class="table-overflow scrollable leaderboard-scroll-height">
                              <table class="leaderboard-table">
                                 <tbody>
                                    <tr>
                                       <th class="">Id</th>
                                       <th class="">Lab/Scenario Name</th>
                                       <th class="">Date/Time</th>
                                       <th class="">Action</th>
                                    </tr>
                                    <tr>
                                       <td></td>
                                       <td></td>
                                       <td></td>
                                       <td class="status-alot">Alot</td>
                                    </tr>
                                    <tr>
                                       <td></td>
                                       <td></td>
                                       <td></td>
                                       <td class="status-cancel">Cancel</td>
                                    </tr>
                                    <tr>
                                       <td></td>
                                       <td></td>
                                       <td></td>
                                       <td class="status-alot">Alot</td>
                                    </tr>
                                    <tr>
                                       <td></td>
                                       <td></td>
                                       <td></td>
                                       <td class="status-alot">Alot</td>
                                    </tr>
                                    <tr>
                                       <td></td>
                                       <td></td>
                                       <td></td>
                                       <td class="status-cancel">Cancel</td>
                                    </tr>
                                 </tbody>
                              </table>
                           </div>
                        </div>

                     </div>
                  </section>
                  <div class="fixed">
                     <div class="calendar-cross-icon"><a href="#"><i class="fa fa-times" aria-hidden="true"></i></a></div>
                     <div class="clock">
                        <div id="Date"></div>
                        <ul class="ull">
                           <li class="lii" id="hours"></li>
                           <li class="lii" id="point">:</li>
                           <li class="lii" id="min"></li>
                           <li class="lii" id="point">:</li>
                           <li class="lii" id="sec"></li>
                           <li class="lii" id="ampm"></li>

                        </ul>
                     </div>

                     <div id="calendar"></div>
                     <div class="calendar-btn"><a href="<?php echo $CFG->wwwroot . '/calendar/view.php?view=month'; ?>" class="create-event">Create Event</a></div>
                  </div>
                  <?php
                  // code for moodle calender

                  // $view = 'month';
                  // $calendar = calendar_information::create($time, 1, $categoryid);
                  // $renderer = $PAGE->get_renderer('core_calendar');
                  // echo $renderer->start_layout();
                  // echo html_writer::start_tag('div', ['class' => 'heightcontainer', 'data-calendar-type' => 'main-block']);
                  // list($data, $template) = calendar_get_view($calendar, $view, true, false, $lookahead);
                  // echo $renderer->render_from_template($template, $data);

                  // echo html_writer::end_tag('div');
                  // end
                  ?>
               </div>
            </div>
         </div>
      </div>
   </div>
   <script src="chart/Chart.js"></script>
   <script src="amd/src/datepicker.min.js"></script>

</body>

</html>

<?php echo $OUTPUT->footer(); ?>