<?php
require_once('../../config.php');
require_once("$CFG->libdir/formslib.php");

global $DB,$USER, $OUTPUT, $PAGE;
require_login();

function array_push_assoc($array, $key, $value){
    $array[$key] = $value;
    return $array;
 }

class create_certificate extends moodleform {
    //Add elements to form
    public function definition() {
        global $CFG,$DB;
        $FORUM_TYPES = ['0'=>"Select"];

        $courses_names = $DB->get_records_sql("SELECT * FROM {course_categories} WHERE parent != 0");
        foreach($courses_names as $courses_names1){
            $FORUM_TYPES = array_push_assoc($FORUM_TYPES, $courses_names1->id, $courses_names1->name);
                }

        $btnstring = 'Save';
        $accept_types = ['.png','.jpg'];
        
        $mform = $this->_form; // Don't forget the underscore! 

        $mform->addElement('header', 'createcertificate', 'Create certificate');

        $mform->addElement('text', 'certificatename', 'Name of certificate', ['maxlength'=> 20]); 
        $mform->addRule('certificatename','* this field is required', 'required');
        // $mform->addRule('certificatename',null, 'alphanumeric');

         // Add elements to your form.
        $mform->setType('certificatename', PARAM_NOTAGS);                   // Set type of element.

        // $mform->addElement('select', 'id', get_string('course', 'local_public'), $FORUM_TYPES);
        // $mform->addRule('id','* this field is required', 'required');

       
        $mform->addElement('filepicker', 'userfile','Image', null, array('maxbytes' => '', 'accepted_types' =>$accept_types));
        $mform->addRule('userfile','* this field is required', 'required');   // Add elements to your form.

        $this->add_action_buttons(true, $btnstring);
    }
    //Custom validation should be added here
    function validation($data, $files) {
        global $DB,$USER;
        $errors= array();
        $table = 'custom_certificate';
        $record=$DB->get_records($table, array('certificate_name'=>$data['certificatename'],'userid'=>$USER->id));
        // $records=$DB->get_records($table, array('course_id'=>$data['id']));
      

        // $record=$DB->get_records_sql("SELECT * FROM {custom_certificate} WHERE certificate_name = $data[certificatename]");
    

        if (count($record) > 0) {
            $errors['certificatename'] = 'Certificate name already exist';
        }
        // if (count($records) > 0) {
        //     $errors['id'] = 'Course  already exist';
        // }
        return $errors;
    }
}


?>