<?php
require_once('../../config.php');

require_login();
// $view = optional_param('view', 'upcoming', PARAM_ALPHA);


global $CFG, $USER,$PAGE,$view;
$PAGE->set_heading('All Course Requests');
$PAGE->set_title('All Course Requests');
$PAGE->set_pagelayout('standard');
$PAGE->requires->css('/local/public/css/dashboard.css'); 
$PAGE->requires->css('/local/public/css/bootstrap.min.css'); 
$PAGE->requires->css('/local/public/css/font-awesome.min.css'); 
$PAGE->requires->css('/local/public/css/style.css'); 
$PAGE->requires->js('/local/public/amd/src/dashboard.js');

if (!is_siteadmin()) {
   throw new moodle_exception("you don't have permission to get this page","core");
}

$draftmodules = $DB->get_records('course');
$draftedcourses = $DB->get_records_sql("SELECT cc.*,u.username FROM {course_categories} cc JOIN {request_subcategory} rs ON rs.subcategory_id = cc.id JOIN {user} u ON u.id = rs.userid WHERE cc.visible = 0 AND rs.status = 0 OR rs.status = 4 ORDER BY cc.id DESC");

$instructor_roleid = $DB->get_field('role','id',['shortname'=>'manager']);
$PAGE->navbar->add('All Course Requests','');
echo $OUTPUT->header();


$draftedcoursescount = 1;
foreach($draftedcourses as $draftedcourses_values){ 
   $rejected =  false;
$drafted = false;
$reviewed = false;
$approved = false;
$pending = false;
$revised = false;
$only_approved_condition = false;
$only_rejected_condition = false;
$approved_decline = false;
$request_pending = false;
   // if (user_has_role_assignment($modules->usercreated,$instructor_roleid)) {  // check user is instructor
//   $userrecord = $DB->get_record('user',['id'=>$modules->usercreated]);
//    $coursename = $DB->get_record_sql("SELECT * FROM {course_categories} WHERE id = $modules->category AND parent != 0");
// if ($coursename) {
   $trackname = $DB->get_record_sql("SELECT * FROM {course_categories} WHERE id = $draftedcourses_values->parent AND parent = 0");
  
   if ($DB->record_exists('request_subcategory', ['subcategory_id' => $draftedcourses_values->id, 'status' => 0])) {  // check if teacher sent course to admin
    
      $get_approved_modules = $DB->count_records_sql("SELECT COUNT(rc.id) FROM {reject_course} rc WHERE rc.course_id IN (SELECT id FROM {course} WHERE category = $draftedcourses_values->id) AND rc.status = 4");
      $get_modules_in_course = $DB->count_records_sql("SELECT COUNT(c.id) FROM {course} c WHERE c.category = $draftedcourses_values->id AND c.visible = 0");
      $get_rejected_modules = $DB->count_records_sql("SELECT COUNT(rc.id) FROM {reject_course} rc WHERE rc.course_id IN (SELECT id FROM {course} WHERE category = $draftedcourses_values->id) AND rc.status = 0");
    
      if ($get_modules_in_course == $get_approved_modules) {
         $only_approved_condition = true;
      }
      elseif ($get_rejected_modules == $get_modules_in_course) {
         $only_rejected_condition = true;
      }
      else {
      
         if ($DB->record_exists_sql("SELECT * FROM {reject_course} WHERE course_id IN (SELECT id FROM {course} WHERE category = $draftedcourses_values->id) AND status IN (0,3)")) {
            $approved_decline = true;
         } else {
            $request_pending = true;
         }
      }
   }
   elseif ($DB->record_exists('request_subcategory', ['subcategory_id' => $draftedcourses_values->id, 'status' => 4])) {
      $revised = true;
   }

   // if ($modules->visible == 0) { 
   //    if ($DB->record_exists('reject_course', ['course_id'=>$modules->id,'status'=>0])) {
   //       $rejected = true;
   //    }
   //    elseif ($DB->record_exists('reject_course', ['course_id'=>$modules->id,'status'=>2])) {
   //       $drafted = true;
   //    }
   //    elseif ($DB->record_exists('reject_course', ['course_id'=>$modules->id,'status'=>3])) {
   //       $reviewed = true;

   //    }
   //    else {
   //    $pending = true;
   //    }
   // }
   // if ($modules->visible == 1) {
   //    $approved = true;
   // }
   $course_request[]= [
      'draftmodulecount' => $draftedcoursescount,
      'username'=>$draftedcourses_values->username,
      'coursename'=>$draftedcourses_values->name,
      'trackname'=>$trackname->name,
      'courseid'=>$draftedcourses_values->id,
      'trackid'=>$trackname->id,
      'revise'=>$revised,
      'only_approved_condition'=>$only_approved_condition,
      'only_rejected_condition'=>$only_rejected_condition,
      'approved_decline'=>$approved_decline,
      'request_pending'=>$request_pending

      // 'rejected'=>$rejected,
      // 'drafted'=>$drafted,
      // 'reviewed'=>$reviewed,
      // 'pending'=>$pending,
      // 'approved'=>$approved

   ];
   $draftedcoursescount++;


}
$data = [
   'course_request' =>$course_request
];
echo $OUTPUT->render_from_template('local_public/allcourse_request',$data);
echo $OUTPUT->footer(); 
?>
