<?php
require_once('../../config.php');
require_once("{$CFG->libdir}/completionlib.php");
require_once("{$CFG->libdir}/accesslib.php");
class tableuser extends table_sql
{

    function __construct($uniqueid)
    {
        parent::__construct($uniqueid);
        // Define the list of columns to show.

        $columns = array('id', 'userid',  'username', 'email', 'categoryname', 'parent', 'fullname', 'badgename','name','timeaccess');
        $this->define_columns($columns);

        // Define the titles of columns to show in header.
        $headers = array('S.no', 'UEID', 'User Name', 'Status', 'Track', 'Courses', 'Modules','Badge Name', 'Certificate name','Last Accessed');
        $this->define_headers($headers);
    }


    function col_username($row){
       return(html_writer::start_tag('a', array('href'=>"studentactivity.php?id=$row->userid&&moduleid=$row->courseid&&trackid=$row->parent&&courseid=$row->category")).$row->username.
         html_writer::end_tag('a'));
    }
    function col_badgename($row)
    {

        global $DB, $USER;
        if ($row->badgename) {

            return ($row->badgename);
        } else {
            return ("not win");
        }
    }
    function col_parent($row)
    {

        // var_dump($row);

        global $DB, $USER;
        if ($row->parent) {

            return ($row->categoryname);
        } else {
            return (null);
        }
    }

    function col_categoryname($row)
    {
        global $DB, $USER;
    
        $modulename = $DB->get_record('course_categories', array('id' => $row->parent));
        if ($modulename) {
            return ($modulename->name);
        } else {
            return ($row->categoryname);
        }
    }
    
    function col_email($row)
    {
        // var_dump($row->userid);
        global $DB, $USER;
        $course_object = $DB->get_record('course', array('id' => $row->courseid));
        $check = core_completion\progress::get_course_progress_percentage($course_object,$row->userid);
        
     
        if ($check == 100) {
            return("Completed");
         }
         elseif ($check > 0 && $check < 100) {
             return("In Progress");
         }
         elseif ($check == "0") {
             return("Not Start Yet");
         }
         

    }

    function col_fullname($row)
    {
        global $DB, $USER;

        return ($row->fullname);
    }

    function col_timeaccess($row)
    {

        global $DB, $USER;
        if ($row->timeaccess) {
            $time = date("M,d,Y", $row->timeaccess);
        } else {
            $time = "not yet";
        }
        return $time;
    }
}
