<?php
require_once('../../config.php');
require_once("$CFG->libdir/formslib.php");

class table_form extends moodleform
{
    //Add elements to form
    public function definition()
    {
        global $CFG, $DB, $USER;
        $FORUM_TYPES = array();
        $FORUM_TYPES = ["" => "Select", "completed" => "Completed", "inprogress" => "In Progress", "notstart" => "Not Start Yet"];
        $student_roleid = $DB->get_field('role', 'id', ['shortname' => 'student']);

        $mform = $this->_form; // Don't forget the underscore! 
        if (!user_has_role_assignment($USER->id, $student_roleid)) {

            // $mform->addElement('header', 'newfilter', get_string('filter', 'local_public'));
            // $mform->setExpanded('foo', false);
            $mform->addElement('html', '<div class="qheader" style="display:flex; justify-content:space-between;">');

            $mform->setType('Username', PARAM_NOTAGS);                  
            $mform->addElement('text', 'username', get_string('username', 'local_public'), ['style' => 'width:190px']); 
            $mform->addRule('username', get_string('onlyalphanumeric', 'local_public'), 'alphanumeric', 'extraruledata', 'server', false, false);

            // $mform->addElement('text', 'status', get_string('status','local_public')); 
            // $mform->setType('status', PARAM_NOTAGS);                           

            $mform->addElement('select', 'status', get_string('status', 'local_public'), $FORUM_TYPES);

            $mform->addElement('text', 'studentid', get_string('id', 'local_public'));
            $mform->addRule('studentid', get_string('onlynumeric', 'local_public'), 'numeric', 'extraruledata', 'server', false, false);

            $mform->addElement('text', 'course', get_string('track', 'local_public'), ['style' => 'width:190px']); 
            $mform->addRule('course', get_string('onlyalphanumeric', 'local_public'), 'alphanumeric', 'extraruledata', 'server', false, false);
            $mform->setType('Course', PARAM_NOTAGS);                  

            $mform->addElement('text', 'module', get_string('course', 'local_public'), ['style' => 'width:190px']); 
            $mform->addRule('module', get_string('onlyalphanumeric', 'local_public'), 'alphanumeric', 'extraruledata', 'server', false, false);
            $mform->setType('module', PARAM_NOTAGS);                 

            $mform->addElement('text', 'lesson', get_string('module', 'local_public'), ['style' => 'width:190px']); 
            $mform->addRule('lesson', get_string('onlyalphanumeric', 'local_public'), 'alphanumeric', 'extraruledata', 'server', false, false);
            $mform->setType('lesson', PARAM_NOTAGS);                  

            $mform->addElement('html', '</div>');
            $this->add_action_buttons($cancel = true, $submitlabel = "Apply Filter");
        }
    }
    //Custom validation should be added here
    function validation($data, $files)
    {
        return array();
    }
}
