<?php
require_once('../../config.php');
global $DB, $OUTPUT, $PAGE, $USER;
require_login();

if (!user_has_role_assignment($USER->id, 5)) {
  return (new moodle_url('/my/'));
}

$PAGE->set_title('Student Dashboard');
$PAGE->set_heading('Student Dashboard');
$PAGE->set_pagelayout('standard');
$breadcrumbs = $PAGE->navigation->add('Student Dashboard',new moodle_url(''),navigation_node::TYPE_CONTAINER);
$breadcrumbs->make_active();
echo $OUTPUT->header();

$jan = [];
$feb = [];
$march = [];
$april = [];
$may = [];
$jun = [];
$july = [];
$aug = [];
$sep = [];
$oct = [];
$nov = [];
$dec = [];


$activity_log = $DB->get_records('course_modules_completion', ['userid' => $USER->id, 'completionstate' => 1]);
foreach ($activity_log as $activity_log1) {
  $month = date("m", $activity_log1->timemodified);
  


  if ((int)$month == 12) {
    $dec[] = $month;
  }
  if ((int)$month == 11) {
    $nov[] = $month;
  }
  if ((int)$month == 10) {
    $oct[] = $month;
  }
  if ((int)$month == 9) {
    $sep[] = $month;
  }
  if ((int)$month == 8) {
    $aug[] = $month;
  }
  if ((int)$month == 7) {
    $july[] = $month;
  }
  if ((int)$month == 6) {
    $jun[] = $month;
  }
  if ((int)$month == 5) {
    $may[] = $month;
  }
  if ((int)$month == 4) {
    $april[] = $month;
  }
  if ((int)$month == 3) {
    $march[] = $month;
  }
  if ((int)$month == 2) {
    $feb[] = $month;
  }
  if ((int)$month == 1) {
    $jan[] = $month;
  }
}

$activity_log_array = [count($jan), count($feb), count($march), count($april), count($may), count($jun), count($july), count($aug), count($sep), count($oct), count($nov), count($dec)];
$highest_value =  max($activity_log_array);
$activity_log_array_string =  implode(",", $activity_log_array);


$notepad_data = $DB->get_records('ltool_note_data', ['userid' => $USER->id]);


$bookmark_tracks = $DB->get_records_sql(" SELECT cc.name,cc.id,bc.time_created FROM {bookmark_tracks} bc JOIN {course_categories} cc ON cc.id = bc.trackid WHERE bc.userid = $USER->id ");

$bookmark_course = $DB->get_records_sql(" SELECT cc.name,cc.id,bc.time_created FROM {bookmark_course} bc JOIN {course_categories} cc ON cc.id = bc.courseid WHERE bc.userid = $USER->id ");


$i = 0;
$y = 0;
$unique_track_ids = [];
$array = [];

$user_enrol_courses = enrol_get_users_courses($USER->id, $onlyactive = false, $fields = null, $sort = null);
foreach ($user_enrol_courses as $user_enrol_coursesss) {
  $array[] =  $user_enrol_coursesss->category;
}

$array = array_unique($array);


for ($i = 0; $i <= count($array); $i++) {
  $enrol_courses = $DB->get_records_sql(" SELECT * FROM {course_categories} WHERE id ='$array[$i]' AND parent != 0 ");

  foreach ($enrol_courses as $enrol_courses1) {
    $enrol_courses2 = $DB->get_records_sql("SELECT * FROM {course_categories} WHERE id =$enrol_courses1->parent AND parent = 0");
    foreach ($enrol_courses2 as $enrol_tracks) {
      $unique_track_ids[] = $enrol_tracks->id;
    }
  }
}

$unique_track_ids = array_unique($unique_track_ids);


$user_enrol_ids = $DB->get_records('user_enrolments', ['userid' => $USER->id]);

$popular_courseid = $DB->get_records_sql("SELECT courseid,count(courseid) FROM {user_lastaccess} GROUP BY courseid ORDER BY count(courseid) DESC");

// $enrol_courses = enrol_get_users_courses($USER->id, $onlyactive = false, $fields = null, $sort = null);

$totalenrol_courses = count(enrol_get_users_courses($USER->id, $onlyactive = false, $fields = null, $sort = null));
$usercreated = $DB->get_record('user', ['id' => $USER->id]);

$usercreated_date = date('m/d/Y', $usercreated->timecreated);
if ($usercreated->lastlogin == 0) {
  $lastaccess = "recently login";
  $lastaccess1 = date('m/d/Y h:i:sa');
} else {
  $lastaccess = date('m/d/Y', $usercreated->lastlogin);
  $lastaccess1 = date('m/d/Y h:i:sa', $usercreated->lastlogin);
}

$usercreated_date1 = date('m/d/Y h:i:sa', $usercreated->timecreated);

$start_date = new DateTime($usercreated_date1);
$since_start = $start_date->diff(new DateTime($lastaccess1));



?>
<!DOCTYPE html>
<html lang="en">

<head>
  <!-- <title>Labz LMS</title> -->
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">
  <link rel="stylesheet" type="text/css" href="style.css">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/normalize/5.0.0/normalize.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta2/css/all.min.css" integrity="sha512-YWzhKL2whUzgiheMoBFwW8CKV4qpHQAEuvilg9FAn5VJUDwKZZxkJNuGM4XkWuk94WCrrwslk8yWNGmY1EduTA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
  <link rel="preconnect" href="https://fonts.googleapis.com" />
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@500&display=swap" rel="stylesheet" />
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
  <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.5.0/Chart.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.9.4/Chart.js"></script>
  <style type="text/css">
    .scrollit {
      overflow-y: scroll;
      height: 400px;
    }




    .flex {

      border-radius: 8px;

    }
    /* .p + p{
      float:left;
    } */
#page-content.blocks-pre .region-main #region-main {
    padding: 0px !important;
    background:inherit !important;
    border:inherit !important;
}

    /*
    .graph {
      background: #050534 !important;
    }*/
    .graph .scrollit p {
      font-size: 14px;
      display: inline;
    }
/*
    ul#tabs-nav li:hover,
    ul#tabs-nav li.active {
      background: #ffffff6b !important;
    }*/

    .branch {
      color: #fff;
      border: none !important;
    }

    /*add codepen*/

    .container2 {
      display: grid;
      grid-template-columns: repeat(1, 160px);
      grid-gap: 80px;
      margin: auto 0;
      justify-content: center;
    }

    @media (min-width: 420px) and (max-width: 659px) {
      .container2 {
        grid-template-columns: repeat(2, 160px);
      }
    }

    @media (min-width: 660px) and (max-width: 899px) {
      .container2 {
        grid-template-columns: repeat(3, 160px);
      }
    }

    @media (min-width: 900px) {
      .container2 {
        grid-template-columns: repeat(4, 160px);
      }
    }

    .container2 .box {
      width: 100%;
    }

    .container2 .box h2 {
      display: block;
      text-align: center;
      /*  color: #fff;*/
    }

    .container2 .box .chart {
      position: relative;
      width: 100%;
      height: 100%;
      text-align: center;
      font-size: 40px;
      line-height: 160px;
      height: 160px;
      /*  color: #fff;*/
    }

    .container2 .box canvas {
      position: absolute;
      top: 0;
      left: 0;
      width: 100%;
      width: 100%;
    }

    /**Timeline code**/
    ul.timeline {
      list-style-type: none;
      position: relative;
    }

    ul.timeline:before {
      content: ' ';
      background: #d4d9df;
      display: inline-block;
      position: absolute;
      left: 16px;
      width: 2px;
      height: 100%;
      z-index: 400;
    }

    ul.timeline>li {
      margin: 20px 0;
      padding-left: 20px;
    }

    /*ul.timeline > li:before {
    content: ' ';
    background: white;
    display: inline-block;
    position: absolute;
    border-radius: 50%;
    border: 3px solid #000022;
    left: 7px;
    width: 20px;
    height: 20px;
    z-index: 400;
}*/

    #page-local-public-student_dashboard .graph {
      height: 386px;
      overflow: hidden;
      background:#fff;
      border: 1px solid #ffffff24;
    }

    #block-region-side-pre{
      width:100%;
    }
    .course-design{
          width: 100%;
          display: flex;
          justify-content: space-between;
    }
    .course-design select{
      border-radius:5px;
    }

   

    tbody,
    td,
    tfoot,
    th,
    thead,
    tr {
      padding: 10px;
    }

    .tab2 {
      overflow: hidden;
      border: 1px solid #ccc;
      background-color: #f1f1f1;
    }

    /* Style the buttons inside the tab2 */
    .tab2 button {
      background-color: inherit;
      float: left;
      border: none;
      outline: none;
      cursor: pointer;
      padding: 14px 16px;
      transition: 0.3s;
      font-size: 17px;
    }

    /* Change background color of buttons on hover */
    .tab2 button:hover {
      background-color: #ddd;
    }

    /* Create an active/current tab2link class */
    .tab2 button.active {
      background-color: #ccc;
    }

    /* Style the tab2 content */
    .tab2content {
      display: none;

      border-top: none;
    }

    .tab2links:hover {
      cursor: pointer;
    }

    /*Second tabs code*/
    /* Tabs */
    .tab-content {
      background: inherit;
      padding: inherit;
    }

    ul#tabs-nav {
      list-style: none;
      margin: 0;
      overflow: auto;
    }

    ul#tabs-nav li {
      float: left;
      cursor: pointer;
    }


    ul#tabs-nav li:hover,
    ul#tabs-nav li.active {
      background: #08E;
    }

    #tabs-nav li a {
      text-decoration: none;
      color: #FFF;
      font-weight: 500;
      line-height: 0;
      background: transparent !important;
    }

    ul {
      list-style: none;
    }

    .ull li {
      margin: 10px 0px;
    }

    /*06-12-2022 ak*/



    .tab2links:hover {
      background: #ffffff6b;
      transition: 0.4s;
    }

    .tab2links.active {
      background: #ffffff6b;
    }



    @keyframes chartjs-render-animation {
      from {
        opacity: .99
      }

      to {
        opacity: 1
      }
    }

    .chartjs-render-monitor {
      animation: chartjs-render-animation 1ms
    }

    .chartjs-size-monitor,
    .chartjs-size-monitor-expand,
    .chartjs-size-monitor-shrink {
      position: absolute;
      direction: ltr;
      left: 0;
      top: 0;
      right: 0;
      bottom: 0;
      overflow: hidden;
      pointer-events: none;
      visibility: hidden;
      z-index: -1
    }

    .chartjs-size-monitor-expand>div {
      position: absolute;
      width: 1000000px;
      height: 1000000px;
      left: 0;
      top: 0
    }

    .chartjs-size-monitor-shrink>div {
      position: absolute;
      width: 200%;
      height: 200%;
      left: 0;
      top: 0
    }

    .geraph-section {
      padding-top: 50px;
    }

    .sdsfsfsadsd li {
      background: #ffffff36;
      padding: 2px 20px;
      border-radius: 20px;
      transition: 0.4s;
      margin-bottom: 0.5rem;
      font-size: 15px;
    }

    .sdsfsfsadsd li:hover {
      background: #ffffff6b !important;
      transition: 0.4s;
    }

    h5 {
      font-size: 1.0625rem !important;
      /* font-weight: 600; */
    }

    .card p,
    a {
      font-size: 14px;
    }

    .card tbody,
    th {
      font-size: 12px;
    }

    .card tbody,
    td {
      font-size: 14px;
    }

    .sdsfsfsadsd li.active {
      background: #ffffff6b;
    }
    #region-main {
    margin-top: 0px;
}

    #region-main {
      padding-top: 0px !important;
    }

/*    table#certificates a {
      color: white !important;
    }
*/
    /*06-12-2022 ak*/
  </style>
  <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/easy-pie-chart/2.1.6/jquery.easypiechart.min.js" integrity="sha512-DHNepbIus9t4e6YoMBSJLwl+nnm0tIwMBonsQQ+W9NKN6gVVVbomJs9Ii3mQ+HzGZiU5FyJLdnAz9a63ZgZvTQ==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
  <script type="text/javascript">
    $(function() {
      $('.chart').easyPieChart({
        size: 200,
        barColor: "#17d3e6",
        scaleLength: 0,
        lineWidth: 10,
        trackColor: "#373737",
        lineCap: "circle",
        animate: 2000,
      });
    });
  </script>
</head>

<body>
  <input type="hidden" id="monthactivitydata" value="<?php echo  $activity_log_array_string; ?>">
  <input type="hidden" id="maxdata" value="<?php echo  $highest_value; ?>">

  <div class="row mt-2">
    <div class="col-md-12">
      <div class="box-1 graph">
        <div class="box-inside">
          <div class="my-course">
            <h5>Tracks</h5>
          </div>
          <div class="my-course-cutom float-right">
            <a href="view_all_tracks.php">
              <h5>View All</h5>
            </a>
          </div>
        </div>
        <div class="prnt">
          <div class="box-1 mb-2">

            <div class="flex py-4">
              <div class="container2">

                <?php

                for ($y = 0; $y <= count($unique_track_ids); $y++) {

                  if ($DB->record_exists('course_categories', ['id' => $unique_track_ids[$y]])) {

                    $enrol_track_names = $DB->get_record('course_categories', ['id' => $unique_track_ids[$y]]);
                    // $category_count = 0;
                    // $course_category=[];


                    // $total_course_in_track = 0;
                    $total_completed_module1 = [];
                    $total_module = 0;
                    $percentage_of_completion = 0;
                    for ($i = 0; $i <= count($array); $i++) {
                      $enrol_courses = $DB->get_record_sql(" SELECT * FROM {course_categories} WHERE id = '$array[$i]' AND parent = $enrol_track_names->id");
                      if ($enrol_courses) {

                        $course_record = $DB->get_records('course', ['category' => $enrol_courses->id]);
                        foreach ($course_record as $course_record1) {
                          $context = context_course::instance($course_record1->id);

                          if (is_enrolled($context, $USER->id, '', true)) {

                            //  $course_object = $DB->get_record('course', ['id' => $course_record1->id]);
                            //  $check = core_completion\progress::get_course_progress_percentage($course_object, $USER->id);

                            $course_moduleid = $DB->get_records_sql("SELECT * FROM {course_modules} WHERE course = $course_record1->id AND module != 10");
                            $total_module = count($course_moduleid) + $total_module;
                            foreach ($course_moduleid as $course_moduleid1) {
                              $completed_module = $DB->get_record_sql("SELECT * FROM {course_modules_completion} WHERE userid = $USER->id AND  completionstate = 1 AND coursemoduleid = $course_moduleid1->id");

                              // foreach($completed_module as $completed_module1){
                              if ($completed_module->id) {
                                $total_completed_module1[] = $completed_module->id;
                              }
                              // }
                            }
                          }
                        }
                      }
                    }
                    //  var_dump($total_module);
                    //  var_dump(count($total_completed_module1));
                    //  die;
                    $percentage_of_completion = (count($total_completed_module1) / $total_module) * 100;
                    //  $totalcompletedmodule = (count($course_count) / $total_course_in_track) * 100;

                ?>
                    <div class="box">
                      <div class="chart" data-percent="<?php echo round($percentage_of_completion); ?>" data-scale-color="#ffb400" style="font-size: 18px;"><?php echo round($percentage_of_completion); ?></div>
                      <h2 style="font-size: 14px; margin-top: 12px;"><?php echo $enrol_track_names->name; ?></h2>
                    </div>
                <?php
                  }
                  if ($y > 2) {
                    break;
                  }
                }
                ?>

              </div>

            </div>


          </div>

        </div>
      </div>



    </div>
  </div>
  <div class="row mt-4">
    <div class="col-md-6">
      <div class="box-1 graph">
        <div class="box-inside">
          <div class="my-course">
            <h5>Bookmarked Courses</h5>
          </div>
          <div class="my-course d-flex">
            <h5 class="mr-2 tab2links active" onclick="openCity(event, 'course')">Course</h5>
            <h5 class="tab2links" onclick="openCity(event, 'track')">Track</h5>
          </div>
        </div>
        <div class="achievements-txt">
          <ul class="timeline tab2content" id="course" style="display:block;">
            <?php
            foreach ($bookmark_course as $bookmark_courses) {
              $dt = new DateTime($bookmark_courses->time_created);

            ?>
              <li>
                <a href="#"><?php echo $bookmark_courses->name; ?> <a href="<?php echo $CFG->wwwroot . '/local/report/modules.php?id=' . $bookmark_courses->id; ?>" class="ml-3">View</a></a>
                <a href="#" class="float-right"><?php echo $dt->format('d-M-Y'); ?></a>
              </li>


            <?php
            }
            ?>

          </ul>
          <ul class="timeline tab2content" id="track">
            <?php
            foreach ($bookmark_tracks as $bookmark_track) {
              $dt = new DateTime($bookmark_track->time_created);

            ?>

              <li>
                <a href="#"><?php echo $bookmark_track->name; ?><a href="<?php echo $CFG->wwwroot . '/local/report/courses.php?id=' . $bookmark_track->id; ?>" class="ml-3">View</a></a>
                <a href="#" class="float-right"><?php echo $dt->format('d-M-Y'); ?></a>

              </li>

            <?php
            }
            ?>


          </ul>
        </div>
      </div>
    </div>
    <div class="col-md-6">
      <div class="box-1 graph">
        <div class="box-inside sdsfsfsadsd mb-4">
          <div class="my-course ">
            <h5>Achievements</h5>
          </div>
          <div class="my-course d-flex">
            <ul id="tabs-nav">
              <li class="mr-2"><a href="#tab1">Badges</a></li>
              <li><a href="#tab2">Certificates</a></li>
            </ul>
          </div>
        </div>
        <div class="tab2le">
          <div class="scrollit" id="style-3">
            <div class="tabs">
              <!-- END tabs-nav -->
              <div id="tabs-content">
                <div id="tab1" class="tab-content">

                  <table id="badges" class="table tabcontent" style="width: 100%;">
                    <thead>
                      <th class="text-white">Course Name</th>
                      <!-- <th class="text-white"> Status</th> -->
                      <th class="text-white">Badge</th>
                    </thead>
                    <tbody>
                      <?php

                      for ($z = 0; $z <= count($array); $z++) { 
                       
                        $courses_enrolled = $DB->get_record_sql(" SELECT * FROM {course_categories} WHERE id = '$array[$z]' AND parent != 0");
                        if ($courses_enrolled) {
                        $module_records = $DB->get_records('course', ['category' => $courses_enrolled->id]);
                        $module_count = [];
                        $total_module_in_category = 0;
                      foreach ($module_records as $module_records1) {
                        $context = context_course::instance($module_records1->id);

                        if (is_enrolled($context, $USER->id, '', true)) {
                        
                          $course_object = $DB->get_record('course', ['id' => $module_records1->id]);
                          $check = core_completion\progress::get_course_progress_percentage($course_object, $USER->id);
                          if ($check == 100) {
                            $module_count[] = $course_object->id;
                          }
                          $total_module_in_category++;
                        }
                      }
                    
                        if ($total_module_in_category == count($module_count)) {
                          $status = "completed";
                          if (!$DB->record_exists('assign_badge', ['studentid' => $USER->id, 'course_id' => $courses_enrolled->id])) {
                            $html = '
                            <script src="https://code.jquery.com/jquery-3.6.1.min.js" integrity="sha256-o88AwQnZB+VDvE9tvIXrMQaPlFFSUTR+nldQm1LuPXQ=" crossorigin="anonymous"></script>
                            <script>
                            $.ajax({
                                type: "POST",
                                url: "'.$CFG->wwwroot.'/local/public/assign_badge.php",
                                dataType: "json",
                                data: {
                                  studentid:'.$USER->id.',
                                  courseid:'.$courses_enrolled->id.',
                                  coursename: "'.$courses_enrolled->name.'",
                                  studentname:"'.$USER->firstname.'"
                                
                                },
                                async: false,
                                success: function(json) {
                                  
                                }
                            
                            });
                            </script>
                            ';
                            echo $html;
                          }
                      
                         $issued_badges = $DB->get_record('custom_badge', ['course_id' => $courses_enrolled->id]);
                        if ($issued_badges) {
                          $badgename = $issued_badges->badge_name;
                        }
                        else {
                          $badgename = "not created";
                        }
                     
                      // foreach ($user_enrol_courses as $user_enrol_courses1) {
                      //   $issued_badges = $DB->get_records('badge_issued', ['userid' => $USER->id]);
                      //   foreach ($issued_badges as $issued_badges1) {
                      //     $badges_names = $DB->get_record('badge', ['courseid' => $user_enrol_courses1->id, 'id' => $issued_badges1->badgeid]);
                      //     if ($badges_names->name) {

                      ?>
                            <tr>
                              <td><?php echo $courses_enrolled->name; ?></td>
                              <!-- <td><?php echo $status; ?></td> -->
                              <td><?php echo  $badgename; ?></td>
                            </tr>
                      <?php
                        }
                      }
                      }
                      ?>

                    </tbody>
                  </table>

                </div>
                <div id="tab2" class="tab-content">

                  <table id="certificates" class="table tabcontent" style="width: 100%;">
                    <thead>
                      <th class="text-white">Track Name</th>
                      <!-- <th class="text-white"> Status</th> -->
                      <th class="text-white">Certificate</th>
                    </thead>
                    <tbody>
                      <?php

                      for ($y = 0; $y <= count($unique_track_ids); $y++) {
                        $category_count = 0;
                        $course_category = [];
                        if ($DB->record_exists('course_categories', ['id' => $unique_track_ids[$y]])) {
                          $enrol_track_names = $DB->get_record('course_categories', ['id' => $unique_track_ids[$y]]);
                        

                        for ($i = 0; $i <= count($array); $i++) {
                          $enrol_courses = $DB->get_record_sql(" SELECT * FROM {course_categories} WHERE id = '$array[$i]' AND parent = $enrol_track_names->id");

                          if ($enrol_courses) {
                            $course_record = $DB->get_records('course', ['category' => $enrol_courses->id]);

                            $course_count = [];

                            $total_course_in_category = 0;

                            foreach ($course_record as $course_record1) {
                              $context = context_course::instance($course_record1->id);

                              if (is_enrolled($context, $USER->id, '', true)) {

                                $course_object = $DB->get_record('course', ['id' => $course_record1->id]);
                                $check = core_completion\progress::get_course_progress_percentage($course_object, $USER->id);
                                if ($check == 100) {
                                  $course_count[] = $course_object->id;
                                }
                                $total_course_in_category++;
                              }
                            }
                            if (count($course_count) ==  $total_course_in_category) {
                              $course_category[] = $enrol_courses->id;
                            }
                            $category_count++;
                          }
                        }
                        if ($category_count == count($course_category)) {
                          if (!$DB->record_exists('assign_certificate', ['studentid' => $USER->id, 'track_id' => $enrol_track_names->id])) {
                            $html = '
                            <script src="https://code.jquery.com/jquery-3.6.1.min.js" integrity="sha256-o88AwQnZB+VDvE9tvIXrMQaPlFFSUTR+nldQm1LuPXQ=" crossorigin="anonymous"></script>
                            <script>
                            $.ajax({
                                type: "POST",
                                url: "'.$CFG->wwwroot.'/local/public/assign_badge.php",
                                dataType: "json",
                                data: {
                                  studentid:'.$USER->id.',
                                  trackid:'.$enrol_track_names->id.',
                                  track_name: "'.$enrol_track_names->name.'",
                                  studentname:"'.$USER->firstname.'"
                                
                                },
                                async: false,
                                success: function(json) {
                                  
                                }
                            
                            });
                            </script>
                            ';
                            echo $html;
                          }
                      
                          $status = "completed";
                          $event = "visible";
                       
                        //  else {
                        //   $status = "not completed";
                        //   $event = "none";
                        // }
                      ?>
                        <tr>
                          <td><?php echo $enrol_track_names->name; ?></td>
                          <!-- <td><?php echo $status; ?></td> -->
                          <td><?php echo html_writer::div("<a class='mod_quiz-next-nav' style='color:#0d6efd; pointer-events: $event' href='certificate.php?id=$USER->id&&trackid=$enrol_track_names->id'>Get Certificate</a>");
                              ?>
                          <?php
                        }
                      }
                      }

                          ?>

                    </tbody>
                  </table>


                </div>

              </div> <!-- END tabs-content -->
            </div> <!-- END tabs -->
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="row mt-4">
    <div class="col-md-6">
      <div class="box-1 graph">
        <div class="box-inside">
          <div class="my-course">
            <h5>Community Leader Board</h5>
          </div>
        </div>
        <div class="tab2le">
          <div class="scrollit" id="style-3">
            <table>
              <tr>
                <th>Ranking</th>
                <th>Member</th>
                <th>score</th>
              </tr>
              <?php
              $i = 0;
              $userid_array = [];
              foreach ($user_enrol_courses as $user_enrol_courses1) {
                $context = context_course::instance($user_enrol_courses1->id);
                $enrolled_users = get_enrolled_users($context, $options = array());
                foreach ($enrolled_users as $enrolled_users1) {
                  $userid_array[] = $enrolled_users1->id;
                }
              }
              $all_userid = implode(",", array_unique($userid_array));
              // var_dump($all_userid);
              $gradecount = $DB->get_records_sql("SELECT  SUM(gg.finalgrade) AS total_score,u.firstname,u.lastname FROM {user} u  JOIN {grade_grades} gg ON u.id =  gg.userid  WHERE gg.userid IN ($all_userid) AND gg.rawgrade > 0 GROUP BY gg.userid  ORDER BY SUM(gg.finalgrade) DESC");
              // var_dump("SELECT  SUM(gg.finalgrade) AS total_score,u.firstname,u.lastname FROM {user} u  LEFT JOIN {grade_grades} gg ON u.id =  gg.userid WHERE u.id IN ($all_userid) GROUP BY gg.userid  ORDER BY SUM(gg.finalgrade) DESC");
              if ($gradecount) {

                foreach ($gradecount as $gradecount1) {
                  $totalgrade = $gradecount1->total_score;
                  $whole_totalgrade = (int) $totalgrade;

                  //  } else {
                  //    $whole_totalgrade = 0;
                  //  }

                  $i++;
                  // if ($gradecount) {
                  //   // var_dump($gradecount);
                  //   $totalgrade = array_sum(array_column($gradecount, 'finalgrade'));
                  // } else {
                  //   $totalgrade = 0;
                  // }
              ?>

                  <tr>
                    <td><?php echo $i; ?></td>
                    <td><?php echo  $gradecount1->firstname . " " . $gradecount1->lastname; ?></td>
                    <td><?php echo  $whole_totalgrade; ?></td>
                  </tr>
              <?php
                }
              }


              ?>
              <!-- <tr>
              <td>2</td>
              <td>May King</td>
            </tr>
             <tr>
              <td>3</td>
              <td>May King</td>
            </tr> -->
            </table>
          </div>
        </div>
      </div>
    </div>
    <div class="col-md-6">
      <div class="box-1 graph">
        <div class="box-inside">
          <div class="my-course">
            <h5>Popular Courses</h5>
          </div>
        </div>
        <div class="scrollit" id="style-3">
          <div class="achievements-txt">
            <ul class="timeline">
              <?php foreach ($popular_courseid as $popular_courseid1) {
                $popular_course = $DB->get_record('course', ['id' => $popular_courseid1->courseid]);
                if ($popular_course->summary) {
                  $description = $popular_course->summary;
                } else {
                  $description = "no description";
                }

              ?>
                <li>
                  <a target="_blank" href="https://www.totoprayogo.com/#"><?php echo  $popular_course->fullname; ?></a>
                  <!-- <a href="#" class="float-right">21 March, 2014</a> -->
                  <p><?php echo  $description; ?></p>
                </li>
              <?php } ?>
              <!-- <li>
                <a href="#">21 000 Job Seekers</a>
                <a href="#" class="float-right">4 March, 2014</a>
                <p>Curabitur purus sem, malesuada eu luctus eget, suscipit sed turpis. Nam pellentesque felis vitae justo accumsan, sed semper nisi sollicitudin...</p>
              </li>
              <li>
                <a href="#">Awesome Employers</a>
                <a href="#" class="float-right">1 April, 2014</a>
                <p>Fusce ullamcorper ligula sit amet quam accumsan aliquet. Sed nulla odio, tincidunt vitae nunc vitae, mollis pharetra velit. Sed nec tempor nibh...</p>
              </li> -->
            </ul>
          </div>
        </div>
      </div>
    </div>
  </div>



  <section class="mt-4 mb-4">
    <div class="row">
      <div class="col-lg-6">
        <div class="custom-graph graph">

          <div class="" style="width:100%;">

            <div class="box-inside">
              <div class="my-course course-design">
                <h5>Your Activity</h5>
                <select name="activity_data" id="activity_data" onchange="get_activity_graph()">
                  <option value="0">Select...</option>
                  <option value="1">Month Wise</option>
                  <option value="2">Week Wise</option>
                  <option value="3">Last 10 days</option>
                </select>
              </div>
            </div>
            <div class="chartjs-size-monitor">
              <div class="chartjs-size-monitor-expand">
                <div class=""></div>
              </div>
              <div class="chartjs-size-monitor-shrink">
                <div class=""></div>
              </div>
            </div>
            <canvas id="canvas" style="display: block; width: 1379px; height: 689px;" width="1379" height="689" class="chartjs-render-monitor"></canvas>
          </div>

        </div>
      </div>
      <style>
        .xvvxsd .timeline>li:before {
          left: 0;
        }

        .xvvxsd .timeline:before {
          left: 8px;
        }

        .xvvxsd .timeline {
          padding: 0 15px;
        }

        .xvvxsd .scrollit {
          overflow-y: scroll;
          height: 272px;
        }
      </style>
      <div class="col-lg-6">
        <div class="xvvxsd  box-1 graph">
          <div class="box-inside">
            <div class="my-course">
              <h5>Notepad</h5>
            </div>
          </div>
          <div class="scrollit" id="style-3">

          <div class="achievements-txt">
              <ul class="timeline ">
              <?php
                foreach ($notepad_data as $notepad_data1) {
                ?>
                  <li>
                    <p class="p"><?php echo $notepad_data1->note; ?></p>
                    <a href="#" class="float-right cont" ><?php echo date('d/m/Y', $notepad_data1->timecreated); ?></a>

                  </li>
                  
                <?php } ?>
                  <!-- <li style="display:flex; justify-content:space-between;">
                     <p class="p">Test</p>
                    <a href="#" class="float-right cont" ><?php echo date('d/m/Y', $notepad_data1->timecreated); ?></a>
                  </li> -->
                  

              </ul>
            </div>

            <!-- <div class="achievements-txt">
              <ul class="timeline ">
                <?php
                // foreach ($notepad_data as $notepad_data1) {
                ?>
                  <li>
                     <a href="#" class="cont">21 000 Job Seekers</a>
                    <p class="p"><?php 
                    // echo $notepad_data1->note; 
                    ?></p>
                    <a href="#" class="float-right cont" ><?php 
                    // echo date('d/m/Y', $notepad_data1->timecreated);
                     ?></a>

                  </li>
                  
                <?php
              //  } 
               ?>

              </ul>
            </div> -->
          </div>
        </div>
      </div>


    </div>
  </section>
  <script>
    //                                                    let bar;


    //                                                   var com =50;
    //                                                  var inprog =40;
    //                                                  var notstart =10;

    //                                                  var xValues = ["Completed", "Inprogress", "Not Start Yet"];
    //                                                  var yValues = [Math.ceil(com), Math.ceil(inprog), Math.ceil(notstart)];
    //                                                  var barColors = [
    //                                                    "#2b5797",
    //                                                    "#FFA500",
    //                                                    "#A020F0"
    //                                                  ];
    //                                                  let ctx = document.getElementById("myChart1").getContext('2d');


    //                                                  bar = new Chart(ctx, {
    //                                                    type: "doughnut",
    //                                                    data: {
    //                                                      labels: xValues,
    //                                                      datasets: [{
    //                                                        backgroundColor: barColors,
    //                                                        data: yValues
    //                                                      }]
    //                                                    },
    //                                                    options: {
    //                                                       legend: {
    //                                                            display: true,
    //                                                            labels: {
    //                                                                fontColor: "#fff"
    //                                                            }
    //                                                          },
    //                                                      title: {
    //                                                        display: true,
    //                                                        text: "Module Report",
    //                                                         fontColor: "#fff"
    //                                                      }
    //                                                    }
    //                                                  });


    // function get_course() {

    //   var track_id = $("#student_track").val();
    //   $.ajax({
    //                   type: "POST",
    //                   url: "get_course.php",
    //                   dataType: "json",
    //                   data: {track_id:track_id},
    //                   async: false,
    //                   success: function(coursedata) {
    //                     if(coursedata.success){
    //                       $('#student_course').html(coursedata.html);
    //                                                      if (bar) {
    //                                                      bar.destroy(); }

    //                                                 var com =coursedata.completed;
    //                                                  var inprog =coursedata.inprogress;
    //                                                  var notstart =coursedata.notstart;

    //                                                  var xValues = ["Completed", "Inprogress", "Not Start Yet"];
    //                                                  var yValues = [Math.ceil(com), Math.ceil(inprog), Math.ceil(notstart)];
    //                                                  var barColors = [
    //                                                    "#2b5797",
    //                                                    "#FFA500",
    //                                                    "#A020F0"
    //                                                  ];

    //                                                  let ctx = document.getElementById("myChart1").getContext('2d');
    //                                                  bar = new Chart(ctx, {
    //                                                    type: "doughnut",
    //                                                    data: {
    //                                                      labels: xValues,
    //                                                      datasets: [{
    //                                                        backgroundColor: barColors,
    //                                                        data: yValues
    //                                                      }]
    //                                                    },
    //                                                    options: {
    //                                                       legend: {
    //                                                            display: true,
    //                                                            labels: {
    //                                                                fontColor: "#fff"
    //                                                            }
    //                                                          },
    //                                                      title: {
    //                                                        display: true,
    //                                                        text: "Module Report",
    //                                                         fontColor: "#fff"
    //                                                      }
    //                                                    }
    //                                                  });

    //                         }
    //                     }




    //   });


    // };

    // function get_modules() {

    //   var course_id = $("#student_course").val();
    //   $.ajax({
    //                   type: "POST",
    //                   url: "get_modules.php",
    //                   dataType: "json",
    //                   data: {course_id:course_id},
    //                   async: false,
    //                   success: function(modulesdata) {
    //                     if(modulesdata.success){
    //                       $('#student_module').html(modulesdata.html);
    //                                                          if (bar) {
    //                                                      bar.destroy(); }
    //                                                     var com =modulesdata.completed;
    //                                                  var inprog =modulesdata.inprogress;
    //                                                  var notstart =modulesdata.notstart;

    //                                                  var xValues = ["Completed", "Inprogress", "Not Start Yet"];
    //                                                  var yValues = [Math.ceil(com), Math.ceil(inprog), Math.ceil(notstart)];
    //                                                  var barColors = [
    //                                                    "#2b5797",
    //                                                    "#FFA500",
    //                                                    "#A020F0"
    //                                                  ];
    //                                                  let ctx = document.getElementById("myChart1").getContext('2d');
    //                                                  bar = new Chart(ctx, {
    //                                                    type: "doughnut",
    //                                                    data: {
    //                                                      labels: xValues,
    //                                                      datasets: [{
    //                                                        backgroundColor: barColors,
    //                                                        data: yValues
    //                                                      }]
    //                                                    },
    //                                                    options: {
    //                                                       legend: {
    //                                                            display: true,
    //                                                            labels: {
    //                                                                fontColor: "#fff"
    //                                                            }
    //                                                          },
    //                                                      title: {
    //                                                        display: true,
    //                                                        text: "Module Report",
    //                                                         fontColor: "#fff"
    //                                                      }
    //                                                    }
    //                                                  });

    //                         }
    //                     }
    //   });
    // }



    //  function get_module_graph(){

    //   var module_id = $("#student_module").val();


    //   $.ajax({
    //                   type: "POST",
    //                   url: "get_module_graph.php",
    //                   dataType: "json",
    //                   data: {module_id:module_id},
    //                   async: false,
    //                   success: function(modulesgraph) {
    //                     if(modulesgraph.success){
    //                                                         if (bar) {
    //                                                      bar.destroy(); }
    //                                                     var com =modulesgraph.completed;
    //                                                  var inprog =modulesgraph.inprogress;
    //                                                  var notstart =modulesgraph.notstart;

    //                                                  var xValues = ["Completed", "Inprogress", "Not Start Yet"];
    //                                                  var yValues = [Math.ceil(com), Math.ceil(inprog), Math.ceil(notstart)];
    //                                                  var barColors = [
    //                                                    "#2b5797",
    //                                                    "#FFA500",
    //                                                    "#A020F0"
    //                                                  ];
    //                                                  let ctx = document.getElementById("myChart1").getContext('2d');

    //                                                  bar = new Chart(ctx, {


    //                                                    type: "doughnut",
    //                                                    data: {
    //                                                      labels: xValues,
    //                                                      datasets: [{
    //                                                        backgroundColor: barColors,
    //                                                        data: yValues
    //                                                      }]
    //                                                    },
    //                                                    options: {
    //                                                       legend: {
    //                                                            display: true,
    //                                                            labels: {
    //                                                                fontColor: "#fff"
    //                                                            }
    //                                                          },
    //                                                      title: {
    //                                                        display: true,
    //                                                        text: "Module Report",
    //                                                         fontColor: "#fff"
    //                                                      }
    //                                                    }
    //                                                  });

    //                         }
    //                     }
    //   });


    //  }

    function show_achievements() {
      var achievement_value = $("#achievements").val();


      if (achievement_value == 1) {
        $("#badges").css("display", "block");
        $("#certificates").css("display", "none");

      }
      if (achievement_value == 2) {
        $("#badges").css("display", "none");
        $("#certificates").css("display", "block");
      }
    }


    $(document).ready(function() {

      $(".bar").click(function() {
        $(".left-position, .right-position").toggleClass('addclass addmarginclass');
      });

    });
  </script>
  <script>
    $(document).ready(function() {
      $("div i").hover(function() {

        // var $this = $(this);
        // $this.nextAll().removeClass('fa-star').addClass( "fa-star-o" );
        // $this.prevUntil("h1").removeClass( "fa-star-o" ).addClass('fa-star');
        // $this.removeClass( "fa-star-o" ).addClass('fa-star');
      });

      //**on mouseOut** change back to fa-star-o OR the result of the click event

      $("div i").mouseout(function() {

        var select = $('.active');
        select.nextAll().removeClass('fa-star').addClass('fa-star-o');
        select.prevUntil("h1").removeClass('fa-star-o').addClass('fa-star');
        select.removeClass('fa-star-o').addClass('fa-star');

      });

      //on Click change star to fa-star and change color to red (prevAll)

      $("div i").click(function() {
        $(this).addClass('active').siblings().removeClass('active');
        $(this).attr("style", "color:#ffd700");
        $(this).prevUntil("h1").css("color", "#ffd700");
        $(this).nextAll().css("color", "#ffd700");

      });



    });
  </script>
  <script>
    $(function() {

      // Developed by IceMaD
      // marcduboc.fr
      // https://github.com/MarcDuboc/qtpie

      // Thanks to Anders Grimsrud for the base : https://codepen.io/agrimsrud/pen/EmCoa

      qtpie = {

        init: function(options) {

          var defaultOptions = {
            id: '#qtpie',
            defaultMsg: '10 BEGIN 0(0%)',
            radius: 70,
            list: false,
            hover: true
          }
          options = $.extend({}, defaultOptions, options);

          // Draw paths
          base = 0;
          $paths = $(options.id).find('path');
          $paths.each(function(index, el) {
            deg = 3.61 * $(this).attr('data-pie');
            // 3.61 instead of 3.6 to fix little svg render bug
            qtpie.draw({
              slice: $(this),
              degree: deg,
              base: base
            });
            base += parseInt(deg);
          });

          // Inside
          $(options.id).find('circle').attr('r', options.radius);
          $(options.id).find('div').append('<div class="qtpieInside">' + options.defaultMsg + '</div>').find('circle').css('fill', $('body').css('background-color'));

          // Hover events
          if (options.hover) {
            $paths.hover(function(event) {
              $current = $(this);
              $inside = $current.parent().parent().find('.qtpieInside')

              $inside.stop().fadeOut(200, function() {
                $inside
                  .css('color', $current.css('fill'))
                  .html($current.attr('data-desc'))
                  .fadeIn(200);
              });
            }, function() {
              $current = $(this);
              $inside = $current.parent().parent().find('.qtpieInside')

              $inside.stop().fadeOut(200, function() {
                $inside
                  .removeAttr('style')
                  .html(options.defaultMsg)
                  .fadeIn(200);
              });
              $(this)
            });
          };

          // List generation (bootstrap style)
          if (options.list) {
            var list = '';
            $paths.each(function(index, el) {
              list += '<li><span class="dot" style="background-color:' + $(this).css('fill') + ';"></span>' + $(this).attr('data-desc') + '</li>';
            });
            $(options.id).append('<ul>' + list + '</ul>');
          };

          // Display at the dn
          $(options.id).show();
        },

        draw: function(options) {

          var defaultOptions = {
            slice: null,
            degree: 0,
            base: 0
          };
          options = $.extend({}, defaultOptions, options);

          var rayon = (options.degree * Math.PI / 180),
            x = Math.sin(rayon) * 100,
            y = Math.cos(rayon) * -100,
            mid = (options.degree > 180) ? 1 : 0,
            anim = 'M 0 0 v -100 A 100 100 1 ' + mid + ' 1 ' + x + ' ' + y + ' z';
          options.slice.attr('d', anim).attr('transform', 'translate(100, 100) rotate(' + base + ')');
        }
      }
      qtpie.init({

      });
      qtpie.init({
        id: '#qtpie-list',
        defaultMsg: 'But not me !',
        radius: 70,
        list: true,
        hover: false
      });
    });
  </script>
  <script>
    function openCity(evt, cityName) {
      var i, tab2content, tab2links;
      tab2content = document.getElementsByClassName("tab2content");
      for (i = 0; i < tab2content.length; i++) {
        tab2content[i].style.display = "none";
      }
      tab2links = document.getElementsByClassName("tab2links");
      for (i = 0; i < tab2links.length; i++) {
        tab2links[i].className = tab2links[i].className.replace(" active", "");
      }
      document.getElementById(cityName).style.display = "block";
      evt.currentTarget.className += " active";
    }
  </script>
  <script type="text/javascript">
    // Show the first tab and hide the rest
    $('#tabs-nav li:first-child').addClass('active');
    $('.tab-content').hide();
    $('.tab-content:first').show();

    // Click function
    $('#tabs-nav li').click(function() {
      $('#tabs-nav li').removeClass('active');
      $(this).addClass('active');
      $('.tab-content').hide();

      var activeTab = $(this).find('a').attr('href');
      $(activeTab).fadeIn();
      return false;
    });
  </script>
  <!-- <script>
      var xValues = ["Completed", "Inprogress", "Not Start Yet"];
      var yValues = [50, 40, 10];
      var barColors = [
        "#2b5797",
        "#FFA500",
        "#A020F0"
      ];

      new Chart("myChart1", {
        type: "doughnut",
        data: {
          labels: xValues,
          datasets: [{
            backgroundColor: barColors,
            data: yValues
          }]
        },
        options: {
          legend: {
            display: true,
            labels: {
              fontColor: "#fff"
            }
          },
          title: {
            display: true,
            text: "Course Report",
            fontColor: "#fff"
          }
        }
      });
    </script>
 -->

  <!-- 
    <script>
      var xValues = ["Completed", "IN Progress", "Not Start Yet"];
      var yValues = [50, 10, 40];
      var barColors = [
        "#2b5797",
        "#FFA500",
        "#A020F0"
      ];

      new Chart("myChart", {
        type: "doughnut",
        data: {
          labels: xValues,
          datasets: [{
            fill: false,
            lineTension: 0,
            backgroundColor: barColors,
            data: yValues
          }]
        },
        options: {
          legend: {
            display: true,
            labels: {
              fontColor: "#fff"
            }
          },
          title: {
            display: true,
            text: "Track Report",
            fontColor: "#fff"
          }
        }
      });
    </script>


    <script>
      var xValues = ["Completed", "IN Progress", "Not Start Yet"];
      var yValues = [50, 22, 28];
      var barColors = [
        "#2b5797",
        "#FFA500",
        "#A020F0"
      ];

      new Chart("myChart3", {
        type: "doughnut",
        data: {
          labels: xValues,
          datasets: [{
            fill: false,
            lineTension: 0,
            backgroundColor: barColors,
            data: yValues
          }]
        },
        options: {
          legend: {
            display: true,
            labels: {
              fontColor: "#fff"
            }
          },
          title: {
            display: true,
            text: "Course Report",
            fontColor: "#fff"
          }
        }
      });
    </script> -->


  <script src="https://cdn2.hubspot.net/hubfs/476360/Chart.js"></script>
  <script src="https://cdn2.hubspot.net/hubfs/476360/utils.js"></script>
  <script>
    var monthwisedata = $("#monthactivitydata").val();
    var maxvalue = parseInt($("#maxdata").val()) + 1;
    var stepwisedata = Math.round(maxvalue / 6);
    var trainindIdArray = monthwisedata.split(',');


    var config = {
      type: 'line',
      data: {
        labels: ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
        datasets: [{
          label: 'Count of Completed Activity',
          backgroundColor: window.chartColors.blue,
          borderColor: window.chartColors.blue,
          fill: false,
          data: trainindIdArray,

        }]
      },
      options: {
        responsive: true,
        title: {
          display: true,

        },
        scales: {
          xAxes: [{
            display: true,
            scaleLabel: {
              display: true,
              labelString: 'Date'
            },
          }],
          yAxes: [{
            display: true,
            //type: 'logarithmic',
            scaleLabel: {
              display: true,
              labelString: 'No. of Activity'
            },
            ticks: {
              min: 0,
              max: maxvalue,
              // forces step size to be 5 units
              stepSize: stepwisedata
            }
          }]
        }
      }
    };

    window.onload = function() {
      var ctx = document.getElementById('canvas').getContext('2d');
      window.myLine = new Chart(ctx, config);
    };

    // document.getElementById('randomizeData').addEventListener('click', function() {
    // 	config.data.datasets.forEach(function(dataset) {
    // 		dataset.data = dataset.data.map(function() {
    // 			return randomScalingFactor();
    // 		});

    // 	});

    // 	window.myLine.update();
    // });

    function get_activity_graph() {
      var activity_value = $("#activity_data").val();
      $.ajax({
        type: "POST",
        url: "activity_data.php",
        dataType: "json",
        data: {
          activity_value: activity_value
        },
        async: false,
        success:function(json){

          var trainindIdArray = json.activity_log_array_string.split(',');
          var labels = json.labels.split(',');


          var maxvalue = parseInt(json.highest_value) + 1;
          var stepwisedata = Math.round(maxvalue / 6);

          if (myLine) {
            myLine.destroy();
          }

          var config = {
      type: 'line',
      data: {
        labels: labels,
        datasets: [{
          label: 'Count of Completed Activity',
          backgroundColor: window.chartColors.blue,
          borderColor: window.chartColors.blue,
          fill: false,
          data: trainindIdArray,

        }]
      },
      options: {
        responsive: true,
        title: {
          display: true,

        },
        scales: {
          xAxes: [{
            display: true,
            scaleLabel: {
              display: true,
              labelString: 'Date'
            },
          }],
          yAxes: [{
            display: true,
            //type: 'logarithmic',
            scaleLabel: {
              display: true,
              labelString: 'Index Returns'
            },
            ticks: {
              min: 0,
              max: maxvalue,
              // forces step size to be 5 units
              stepSize: stepwisedata
            }
          }]
        }
      }
    };

      var ctx = document.getElementById('canvas').getContext('2d');
      window.myLine = new Chart(ctx, config);
   
        }

      });
    }
  </script>

</body>

</html>

<?php

echo $OUTPUT->footer(); ?>