function makequickchart(x, y, z) {
  var xValues = x;
  var yValues = y;
  var barColors = z;
  var ctx = document.getElementById("myChart").getContext("2d");
  if (window.graph != undefined) window.graph.destroy();
  window.graph = new Chart(ctx, {
    type: "doughnut",
    data: {
      labels: xValues,
      datasets: [
        {
          backgroundColor: barColors,
          data: yValues,
        },
      ],
    },

    options: {
      zoomOutPercentage: 50,
      aspectRatio: 1,
      plugins: {
        legend: false,
        responsive: true,
        maintainAspectRatio: false,
      },

      elements: {
        arc: {
          borderWidth: 0,
        },
      },
      title: {
        display: true,
      },
      legend: {
        position: "right",
        labels: {
          boxWidth: 0,
        },
        labels: {
          generateLabels: function (chart) {
            return "";
          },
        },
      },
      xaxis: {
        display: false,
      },
    },
  });
}

function quickanalyis_record() {
  var trackid = $("#selecttrack").val();

  if (trackid.length == 0) {
    makequickchart(xvalueArray, yvalueArray, barcolordata);
    var html = "";
    for (let index = 0; index < xvalueArray.length; index++) {
      html +=
        "<tr><td style='color:" +
        barcolordata[index] +
        "' title='" +
        xvalueArray[index] +
        "'>" +
        xvalueArray[index] +
        "</td><td>" +
        coursescounts_pertrack[index] +
        "</td><td>" +
        yvalueArray[index] +
        "</td></tr>";
    }
    $("#quick_analysis").html(html);
  }
  if (trackid.length <= 5) {
    if (trackid.length == 5) {
      $('input[type="checkbox"]:not(:checked)').attr("disabled", true);
    }
    if (trackid.length < 5) {
      $('input[type="checkbox"]:disabled').prop("disabled", false);
    }
    $.ajax({
      url: "getquickreport.php",
      type: "post",
      dataType: "json",
      data: {
        trackid: trackid,
      },
      async: false,
      success: function (json) {
        $("#quick_analysis").html(json.tabledata);
        makequickchart(json.name, json.usercount, json.chartcolor);
      },
    });
  }
}

var yvaluedata = $("#countlist").val();
var xvaluedata = $("#tracklist").val();
var colordatarecord = $("#colorlist").val();
var courseslists = $("#coursecount").val();

var yvalueArray = yvaluedata.split(",");
var xvalueArray = xvaluedata.split(",");

var arr = []
const tooltip = xvaluedata.split(",")
for(let i = 0;i<tooltip.length;i++){
  arr.push(tooltip[i].split(' ')[0].slice(0,9)+'...')
}

var barcolordata = colordatarecord.split(",");
var coursescounts_pertrack = courseslists.split(",");
makequickchart(arr, yvalueArray, barcolordata);

$("#bulklogout").click(function () {
  var selectedValues = [];
  $("input[type=checkbox]:checked").each(function () {
    if ($(this).val() != 'on') {
      selectedValues.push($(this).val());
    }
  });
  if (selectedValues.length) {
    if (confirm("Are you sure you want to log out from these sessions?")) {
     $.ajax({
    method: 'POST',
    url: 'delete_session.php',
    dataType: 'json',
    async: false,
    data: {
      data: selectedValues,
    },
    success: function (json) {
      if (json.success) {
        alert('Bulk Logout Successfully.');
        window.location.reload();
      }

    }

  })
}
  }
  else {
    alert("Please select atleast one");
  }

})

$(".save-node").click(function () {
  var text = $(".textarea").val();
  if (!text) {
    $("#empty_error").text("Please fill above field");
  } else {
    var htmlPattern = /<[^>]*>/;
    if (htmlPattern.test(text)) {
      $('#empty_error').text('HTML tags are not allowed in the notes.');
    } 
    else {

      $("#empty_error").text("");
      $.ajax({
        url: "notes.php",
        type: "POST",
        data: {
          text: text,
        },
        dataType: "json",
        async: false,
        success: function (data) {
          if (data.success) {
            // Select the first <p> tag inside .newnotes
            var firstPTag = $(".newnotes p:first-child");
  
            if (firstPTag.length === 0) {
              // If there are no <p> tags, create a new <p> tag and append it to .newnotes
              var newP = $(
                "<p class='mb-3 d-flex justify-content-start'><b>1. &nbsp;&nbsp;</b><span>&nbsp;" +
                  text +
                  "</span></p>"
              );
              $(".newnotes").append(newP);
            $(".textarea").val("");
  
            } 
            else if (firstPTag.siblings().length === 0) {
              // If there is only one <p> tag, append the new <p> tag after the first one
              var newP = $(
                "<p class='mb-3 d-flex justify-content-start'><b>2. &nbsp;&nbsp;</b><span>&nbsp;" +
                text +
                "</span></p>"
              );
              $(".newnotes").append(newP);
              $(".textarea").val("");
            } 
            else {
            // Get the text content of the <span> tag inside the <p> tag
            var spanText = firstPTag.find("span").text();
  
            // Add &nbsp; to the beginning of the text content
            spanText = "&nbsp;" + spanText;
  
            // Set the modified text content back to the <span> tag
            firstPTag.find("span").html(spanText);
  
            var newP = $(
              "<p class='mb-3 d-flex justify-content-start'><b>1. &nbsp;&nbsp;</b><span>&nbsp;" +
                text +
                "</span></p>"
            );
            $(".newnotes").prepend(newP);
  
            // Update the serial numbers of existing <p> tags
            $(".newnotes p").each(function (i) {
              $(this)
                .find("b")
                .text(i + 1 + ".");
            });
  
            // Remove the last <p> tag
            $(".newnotes p:last-child").remove();
  
            //  $('<p>' + text + '</p>').insertAfter(".notes");
  
            $(".textarea").val("");
          }
          }
  
        },
      });
    }
  }
});

$(function () {
  $("#selecttrack").multiselect({
    includeSelectAllOption: true,
  });
});

// $('<i class="fa fa-toggle-off officon" aria-hidden="true"></i>').insertAfter('[data-region="popover-region-messages"] .popover-region-toggle');
//     var classname = $("#toggleclass").val();
//     $(".officon").addClass(classname);

//     $(".officon").click(function() {
//       $('.progress + p').attr('style', 'color: #fff !important');

//        // code for black theme
//        if ($(".officon").hasClass("fa-toggle-on")) {
//           $(this).removeClass("fa-toggle-on");
//           $(".navbar.fixed-top").removeClass("fixed-top-white");
//           $("aside").removeClass("aside-white");
//           $(".latest-announcement").removeClass("latest-announcement-white");
//           $("p").removeClass("p-white");
//           $(".columnleft").removeClass("columnleft-white");
//           $("#region-main-box").removeClass("region-main-box-white");
//           $(".bg-grey-box").removeClass("bg-grey-box-white");
//           $(".horizontal-line").removeClass("horizontal-line-white");
//           $(".list").removeClass("list-white");
//           $("select").removeClass("select-white");
//           $(".track-table table th").removeClass("th-white");
//           $(".track-table table td").removeClass("th-white");
//           $(".span").removeClass("span-white");
//           $(".status textarea").removeClass("textarea-white");
//           $(".notes").removeClass("notes-white");
//           $("table th, table td").removeClass("th-white");

//           $('body').removeClass('white-content');

//           var color_mode = "#050534";

//           $.ajax({
//              type: "POST",
//              url: "change_color.php",
//              dataType: "json",
//              data: {
//                 color_mode: color_mode
//              },
//              async: false,
//              success: function(json) {
//                 // $("#myChart").remove();
//                 $('#test2').html('');
//                 // $('#logo').html('<img src="<?php echo $CFG->wwwroot . '/theme/classic/pix/logo.png'; ?>" width="100">');
//              }

//           })

//        }
//        // code for white theme
//        else {
//           $(this).addClass("fa-toggle-on");
//           $(".navbar.fixed-top").addClass("fixed-top-white");
//           $("aside").addClass("aside-white");
//           $(".latest-announcement").addClass("latest-announcement-white");
//           $("p").addClass("p-white");
//           $(".columnleft").addClass("columnleft-white");
//           $("#region-main-box").addClass("region-main-box-white");
//           $(".bg-grey-box").addClass("bg-grey-box-white");
//           $(".horizontal-line").addClass("horizontal-line-white");
//           $(".list").addClass("list-white");
//           $("select").addClass("select-white");
//           $(".track-table table th").addClass("th-white");
//           $(".track-table table td").addClass("th-white");
//           $(".span").addClass("span-white");
//           $(".status textarea").addClass("textarea-white");
//           $(".notes").addClass("notes-white");
//           $("table th, table td").addClass("th-white");

//           $('body').addClass('white-content');
//           $('#darkcss').empty();
//           var delete_record = "white";

//           $.ajax({
//              type: "POST",
//              url: "change_color.php",
//              dataType: "json",
//              data: {
//                 delete_record: delete_record
//              },
//              async: false,
//              success: function(json) {
//                 // $("#myChart").remove();
//                 $("#test2").html('');
//                 // $('#logo').html('<img src="{{{config.wwwroot}}}/theme/classic/pix/logo.png" width="100">');

//              }
//           })
//        }
//     })

$(document).ready(function () {
  $("#calendar").datepicker({
    inline: true,
    firstDay: 1,
    showOtherMonths: true,
    // dayNamesShort: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
    // dayNamesMin:['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat']
  });
  $(".fixed").hide();
  $(".calendar-cross-icon a").click(function () {
    $(".fixed").hide();
  });
  $(".calendar-icon").click(function () {
    $(".fixed").show();
  });
});
$(document).ready(function () {
  // Create two variables with names of months and days of the week in the array
  var monthNames = [
    "January",
    "February",
    "March",
    "April",
    "May",
    "June",
    "July",
    "August",
    "September",
    "October",
    "November",
    "December",
  ];
  var dayNames = [
    "Sunday",
    "Monday",
    "Tuesday",
    "Wednesday",
    "Thursday",
    "Friday",
    "Saturday",
  ];

  // Create an object newDate()
  var newDate = new Date();
  // Retrieve the current date from the Date object
  newDate.setDate(newDate.getDate());
  // At the output of the day, date, month and year
  $("#Date").html(
    dayNames[newDate.getDay()] +
      " " +
      newDate.getDate() +
      " " +
      monthNames[newDate.getMonth()] +
      " " +
      newDate.getFullYear()
  );

  setInterval(function () {
    // Create an object newDate () and extract the seconds of the current time
    var seconds = new Date().getSeconds();
    // Add a leading zero to the value of seconds
    $("#sec").html((seconds < 10 ? "0" : "") + seconds);
  }, 1000);

  setInterval(function () {
    // Create an object newDate () and extract the minutes of the current time
    var minutes = new Date().getMinutes();
    // Add a leading zero to the minutes
    $("#min").html((minutes < 10 ? "0" : "") + minutes);
  }, 1000);

  setInterval(function () {
    // Create an object newDate () and extract the hours of the current time
    var hours = new Date().getHours();
    // console.log(hours);
    // Subtract 12 from the hours if it is greater than 12 to convert to 12-hour format
    var amPm = hours < 12 ? "AM" : "PM";
    hours = hours > 12 ? hours - 12 : hours;
    // Set the AM/PM value based on the hour value
    // Add a leading zero to the value of hours
    $("#hours").html((hours < 10 ? "0" : "") + hours);
    $("#ampm").html(amPm);
  }, 1000);
});
