<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Lang strings for the My overview block.
 *
 * @package    block_myoverview
 * @copyright  Mark Nelson <markn@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

$string['allincludinghidden'] = 'All (including removed from view)';
$string['all'] = 'All';
$string['addtofavourites'] = 'Star this module';
$string['aria:addtofavourites'] = 'Star for';
$string['aria:allcoursesincludinghidden'] = 'Show all modules';
$string['aria:allcourses'] = 'Show all courses except courses removed from view';
$string['aria:card'] = 'Switch to card view';
$string['aria:controls'] = 'Course overview controls';
$string['aria:courseactions'] = 'Actions for current module';
$string['aria:coursesummary'] = 'Course summary text:';
$string['aria:courseprogress'] = 'Course progress:';
$string['aria:customfield'] = 'Show {$a} modules';
$string['aria:displaydropdown'] = 'Display drop-down menu';
$string['aria:favourites'] = 'Show starred courses only';
$string['aria:future'] = 'Show future modules';
$string['aria:groupingdropdown'] = 'Grouping drop-down menu';
$string['aria:inprogress'] = 'Show courses in progress';
$string['aria:list'] = 'Switch to list view';
$string['aria:past'] = 'Show past modules';
$string['aria:removefromfavourites'] = 'Remove star for';
$string['aria:summary'] = 'Switch to summary view';
$string['aria:sortingdropdown'] = 'Sorting drop-down menu';
$string['availablegroupings'] = 'Available filters';
$string['availablegroupings_desc'] = 'Module filters which are available for selection by users. If none are selected, all courses will be displayed.';
$string['card'] = 'Card';
$string['cards'] = 'Cards';
$string['courseprogress'] = 'Module progress:';
$string['completepercent'] = '{$a}% complete';
$string['customfield'] = 'Custom field';
$string['customfiltergrouping'] = 'Field to use';
$string['customfiltergrouping_nofields'] = 'This option requires a course custom field to be set up and visible to everyone.';
$string['displaycategories'] = 'Display categories';
$string['displaycategories_help'] = 'Display the course category on dashboard course items including cards, list items and summary items.';
$string['favourites'] = 'Starred';
$string['future'] = 'Future';
$string['inprogress'] = 'In progress';
$string['lastaccessed'] = 'Last accessed';
$string['layouts'] = 'Available layouts';
$string['layouts_help'] = 'Module overview layouts which are available for selection by users. If none are selected, the card layout will be used.';
$string['list'] = 'List';
$string['myoverview:myaddinstance'] = 'Add a new module overview block to Dashboard';
$string['nocustomvalue'] = 'No {$a}';
$string['past'] = 'Past';
$string['pluginname'] = 'Module overview';
$string['privacy:metadata:overviewsortpreference'] = 'The module overview block sort preference.';
$string['privacy:metadata:overviewviewpreference'] = 'The module overview block view preference.';
$string['privacy:metadata:overviewgroupingpreference'] = 'The module overview block grouping preference.';
$string['privacy:metadata:overviewpagingpreference'] = 'The module overview block paging preference.';
$string['removefromfavourites'] = 'Unstar this module';
$string['searchcourses'] = "Search modules";
$string['shortname'] = 'Short name';
$string['summary'] = 'Summary';
$string['title'] = 'Module name';
$string['aria:hidecourse'] = 'Remove {$a} from view';
$string['aria:showcourse'] = 'Restore {$a} to view';
$string['aria:hiddencourses'] = 'Show modules removed from view';
$string['hidden'] = 'Modules removed from view';
$string['hidecourse'] = 'Remove from view';
$string['hiddencourses'] = 'Removed from view';
$string['show'] = 'Restore to view';
$string['sortbytitle'] = 'Sort by module name';
$string['sortbylastaccessed'] = 'Sort by last accessed';
$string['sortbyshortname'] = 'Sort by short name';
$string['privacy:request:preference:set'] = 'The value of the setting \'{$a->name}\' was \'{$a->value}\'';

// Deprecated since Moodle 4.0.
$string['clearsearch'] = "Clear search";
$string['aria:lastaccessed'] = 'Sort modules by last accessed date';
$string['aria:shortname'] = 'Sort modules by module short name';
$string['aria:title'] = 'Sort modules by module name';
