/*
SQLyog Professional v12.16 (64 bit)
MySQL - 8.0.22 : Database - labz_sms
*********************************************************************
*/


/*!40101 SET NAMES utf8 */;

/*!40101 SET SQL_MODE=''*/;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
CREATE DATABASE /*!32312 IF NOT EXISTS*/`labz_sms` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `labz_sms`;

/*Table structure for table `edrw_Event` */

DROP TABLE IF EXISTS `edrw_Event`;

CREATE TABLE `edrw_Event` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `startdate` varchar(50) DEFAULT NULL,
  `enddate` varchar(50) DEFAULT NULL,
  `amount` varchar(100) DEFAULT NULL,
  `delete_status` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

/*Data for the table `edrw_Event` */

insert  into `edrw_Event`(`id`,`name`,`startdate`,`enddate`,`amount`,`delete_status`) values 

(16,'New Year','1609353000','1609439400','1000','0');

/*Table structure for table `edrw_add_class` */

DROP TABLE IF EXISTS `edrw_add_class`;

CREATE TABLE `edrw_add_class` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `delete_status` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=latin1 ROW_FORMAT=DYNAMIC;

/*Data for the table `edrw_add_class` */

insert  into `edrw_add_class`(`id`,`name`,`delete_status`) values 

(26,'12','0'),

(27,'10','0');

/*Table structure for table `edrw_add_section` */

DROP TABLE IF EXISTS `edrw_add_section`;

CREATE TABLE `edrw_add_section` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=latin1 ROW_FORMAT=DYNAMIC;

/*Data for the table `edrw_add_section` */

insert  into `edrw_add_section`(`id`,`name`) values 

(17,'A');

/*Table structure for table `edrw_address2` */

DROP TABLE IF EXISTS `edrw_address2`;

CREATE TABLE `edrw_address2` (
  `id` int NOT NULL AUTO_INCREMENT,
  `address1` text,
  `address2` text,
  `zip_code` varchar(50) DEFAULT NULL,
  `state` varchar(50) DEFAULT NULL,
  `city` varchar(50) DEFAULT NULL,
  `country` varchar(50) DEFAULT NULL,
  `sid` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

/*Data for the table `edrw_address2` */

/*Table structure for table `edrw_class_and_section_list` */

DROP TABLE IF EXISTS `edrw_class_and_section_list`;

CREATE TABLE `edrw_class_and_section_list` (
  `id` int NOT NULL AUTO_INCREMENT,
  `student_id` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `class_id` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `section_id` varchar(50) DEFAULT NULL,
  `session_id` varchar(50) DEFAULT NULL,
  `delete_status` int DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=88 DEFAULT CHARSET=latin1 ROW_FORMAT=DYNAMIC;

/*Data for the table `edrw_class_and_section_list` */

insert  into `edrw_class_and_section_list`(`id`,`student_id`,`class_id`,`section_id`,`session_id`,`delete_status`) values 

(87,'74','26','17','14',0);

/*Table structure for table `edrw_class_fee` */

DROP TABLE IF EXISTS `edrw_class_fee`;

CREATE TABLE `edrw_class_fee` (
  `id` int NOT NULL AUTO_INCREMENT,
  `class_id` varchar(50) DEFAULT NULL,
  `admission_fee` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `registration_fee` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `transportation_fee` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `tuition_fee` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `total_fee` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `apply_date` int DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=DYNAMIC;

/*Data for the table `edrw_class_fee` */

insert  into `edrw_class_fee`(`id`,`class_id`,`admission_fee`,`registration_fee`,`transportation_fee`,`tuition_fee`,`total_fee`,`apply_date`) values 

(6,'26','1','1','1','1','4',1607625000),

(7,'27','1','1','1','1','4',1608229800);

/*Table structure for table `edrw_class_subject` */

DROP TABLE IF EXISTS `edrw_class_subject`;

CREATE TABLE `edrw_class_subject` (
  `id` int NOT NULL AUTO_INCREMENT,
  `class_id` varchar(50) DEFAULT NULL,
  `subject_id` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=330 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

/*Data for the table `edrw_class_subject` */

insert  into `edrw_class_subject`(`id`,`class_id`,`subject_id`) values 

(273,'26','1'),

(274,'26','2'),

(275,'26','3'),

(329,'27','2');

/*Table structure for table `edrw_class_teacher_list` */

DROP TABLE IF EXISTS `edrw_class_teacher_list`;

CREATE TABLE `edrw_class_teacher_list` (
  `id` int NOT NULL AUTO_INCREMENT,
  `teacher_id` varchar(50) DEFAULT NULL,
  `class_id` varchar(50) DEFAULT NULL,
  `delete_status` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

/*Data for the table `edrw_class_teacher_list` */

/*Table structure for table `edrw_custom_event` */

DROP TABLE IF EXISTS `edrw_custom_event`;

CREATE TABLE `edrw_custom_event` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `startdate` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `enddate` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `amount` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `delete_status` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `user_id` int DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=49 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=DYNAMIC;

/*Data for the table `edrw_custom_event` */

insert  into `edrw_custom_event`(`id`,`name`,`startdate`,`enddate`,`amount`,`delete_status`,`user_id`) values 

(48,'HW- Ch 3, Q. 2a','1607884100','1607884100',NULL,'0',105);

/*Table structure for table `edrw_custom_timetable` */

DROP TABLE IF EXISTS `edrw_custom_timetable`;

CREATE TABLE `edrw_custom_timetable` (
  `id` int NOT NULL AUTO_INCREMENT,
  `timetable_id` int DEFAULT NULL,
  `period_id` int DEFAULT NULL,
  `week_id` int DEFAULT NULL,
  `teacher_id` int DEFAULT NULL,
  `class_id` int DEFAULT NULL,
  `section_id` int DEFAULT NULL,
  `subject_id` int DEFAULT NULL,
  `start_time` varchar(50) DEFAULT NULL,
  `end_time` varchar(50) DEFAULT NULL,
  `adjustment_duration` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=DYNAMIC;

/*Data for the table `edrw_custom_timetable` */

/*Table structure for table `edrw_exam` */

DROP TABLE IF EXISTS `edrw_exam`;

CREATE TABLE `edrw_exam` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `delete_status` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

/*Data for the table `edrw_exam` */

insert  into `edrw_exam`(`id`,`name`,`delete_status`) values 

(5,'Montly Test','0');

/*Table structure for table `edrw_fees` */

DROP TABLE IF EXISTS `edrw_fees`;

CREATE TABLE `edrw_fees` (
  `id` int NOT NULL AUTO_INCREMENT,
  `admission_fee` varchar(50) DEFAULT NULL,
  `registration_fee` varchar(50) DEFAULT NULL,
  `transportation_fee` varchar(50) DEFAULT NULL,
  `tuition_fee` varchar(50) DEFAULT NULL,
  `total_fee` varchar(50) DEFAULT NULL,
  `sid` int DEFAULT NULL,
  `from_date` int DEFAULT NULL,
  `to_date` int DEFAULT NULL,
  `paid` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

/*Data for the table `edrw_fees` */

/*Table structure for table `edrw_holiday` */

DROP TABLE IF EXISTS `edrw_holiday`;

CREATE TABLE `edrw_holiday` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `startdate` varchar(50) DEFAULT NULL,
  `enddate` varchar(50) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `delete_status` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

/*Data for the table `edrw_holiday` */

insert  into `edrw_holiday`(`id`,`name`,`startdate`,`enddate`,`type`,`delete_status`) values 

(9,'Republic','1611599400','1611685800','3','0');

/*Table structure for table `edrw_island` */

DROP TABLE IF EXISTS `edrw_island`;

CREATE TABLE `edrw_island` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1 ROW_FORMAT=DYNAMIC;

/*Data for the table `edrw_island` */

/*Table structure for table `edrw_item` */

DROP TABLE IF EXISTS `edrw_item`;

CREATE TABLE `edrw_item` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `status` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;

/*Data for the table `edrw_item` */

/*Table structure for table `edrw_jobassignment` */

DROP TABLE IF EXISTS `edrw_jobassignment`;

CREATE TABLE `edrw_jobassignment` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` int DEFAULT NULL,
  `assignment_id` varchar(100) DEFAULT NULL,
  `reporting_id` int DEFAULT NULL,
  `dept_id` int DEFAULT NULL,
  `created` int DEFAULT NULL,
  `created_by` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

/*Data for the table `edrw_jobassignment` */

/*Table structure for table `edrw_leave_list` */

DROP TABLE IF EXISTS `edrw_leave_list`;

CREATE TABLE `edrw_leave_list` (
  `id` int NOT NULL AUTO_INCREMENT,
  `leave_type` int DEFAULT NULL,
  `addStartDate` int DEFAULT NULL,
  `addEndDate` int DEFAULT NULL,
  `leave_teacher_id` int DEFAULT NULL,
  `adjust_teacher` int DEFAULT NULL,
  `teacher_list` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=DYNAMIC;

/*Data for the table `edrw_leave_list` */

/*Table structure for table `edrw_period` */

DROP TABLE IF EXISTS `edrw_period`;

CREATE TABLE `edrw_period` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `startdate` varchar(50) DEFAULT NULL,
  `enddate` varchar(50) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1 ROW_FORMAT=DYNAMIC;

/*Data for the table `edrw_period` */

/*Table structure for table `edrw_permission` */

DROP TABLE IF EXISTS `edrw_permission`;

CREATE TABLE `edrw_permission` (
  `id` int NOT NULL AUTO_INCREMENT,
  `permission` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=39 DEFAULT CHARSET=latin1;

/*Data for the table `edrw_permission` */

insert  into `edrw_permission`(`id`,`permission`) values 

(37,'student'),

(38,'demo');

/*Table structure for table `edrw_plantype` */

DROP TABLE IF EXISTS `edrw_plantype`;

CREATE TABLE `edrw_plantype` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) DEFAULT NULL,
  `created` int DEFAULT NULL,
  `modified` int DEFAULT NULL,
  `created_by` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `edrw_plantype` */

/*Table structure for table `edrw_preveducation` */

DROP TABLE IF EXISTS `edrw_preveducation`;

CREATE TABLE `edrw_preveducation` (
  `id` int NOT NULL AUTO_INCREMENT,
  `school_name` varchar(50) DEFAULT NULL,
  `class` varchar(50) DEFAULT NULL,
  `marks` varchar(50) DEFAULT NULL,
  `sid` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=43 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

/*Data for the table `edrw_preveducation` */

/*Table structure for table `edrw_registration` */

DROP TABLE IF EXISTS `edrw_registration`;

CREATE TABLE `edrw_registration` (
  `id` int NOT NULL AUTO_INCREMENT,
  `first_name` varchar(50) DEFAULT NULL,
  `middle_name` varchar(50) DEFAULT NULL,
  `last_name` varchar(50) DEFAULT NULL,
  `dob` varchar(50) DEFAULT NULL,
  `gender` varchar(50) DEFAULT NULL,
  `mobile` varchar(50) DEFAULT NULL,
  `email` varchar(50) DEFAULT NULL,
  `father_name` varchar(50) DEFAULT NULL,
  `mother_name` varchar(50) DEFAULT NULL,
  `address1` text,
  `address2` text,
  `zip_code` varchar(50) DEFAULT NULL,
  `state` varchar(50) DEFAULT NULL,
  `city` varchar(50) DEFAULT NULL,
  `country` varchar(50) DEFAULT NULL,
  `delete_status` varchar(50) DEFAULT NULL,
  `key_email` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`),
  FULLTEXT KEY `first_name` (`first_name`,`email`)
) ENGINE=InnoDB AUTO_INCREMENT=75 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

/*Data for the table `edrw_registration` */

insert  into `edrw_registration`(`id`,`first_name`,`middle_name`,`last_name`,`dob`,`gender`,`mobile`,`email`,`father_name`,`mother_name`,`address1`,`address2`,`zip_code`,`state`,`city`,`country`,`delete_status`,`key_email`) values 

(74,'test','test','test','2020-12-31','1','1234567789','geeta@gmail.com','asasa','asasasasasas','asa','asa','131231','0','0','0','0',NULL);

/*Table structure for table `edrw_retailer` */

DROP TABLE IF EXISTS `edrw_retailer`;

CREATE TABLE `edrw_retailer` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;

/*Data for the table `edrw_retailer` */

/*Table structure for table `edrw_role` */

DROP TABLE IF EXISTS `edrw_role`;

CREATE TABLE `edrw_role` (
  `id` int NOT NULL AUTO_INCREMENT,
  `role` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=47 DEFAULT CHARSET=latin1;

/*Data for the table `edrw_role` */

insert  into `edrw_role`(`id`,`role`) values 

(2,'teacher'),

(3,'staff'),

(5,'admin'),

(12,'student'),

(20,'shamshad'),

(22,'principal'),

(24,'guest teacher'),

(25,'manager'),

(29,'class teacher'),

(46,'teacher');

/*Table structure for table `edrw_role_permission` */

DROP TABLE IF EXISTS `edrw_role_permission`;

CREATE TABLE `edrw_role_permission` (
  `id` int NOT NULL AUTO_INCREMENT,
  `role` varchar(50) NOT NULL DEFAULT '0',
  `permission` varchar(50) NOT NULL DEFAULT '0',
  `status` varchar(50) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=141 DEFAULT CHARSET=latin1;

/*Data for the table `edrw_role_permission` */

/*Table structure for table `edrw_rolelist` */

DROP TABLE IF EXISTS `edrw_rolelist`;

CREATE TABLE `edrw_rolelist` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` varchar(20) DEFAULT NULL,
  `role_id` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=184 DEFAULT CHARSET=latin1;

/*Data for the table `edrw_rolelist` */

insert  into `edrw_rolelist`(`id`,`user_id`,`role_id`) values 

(1,'1','5'),

(178,'2','5');

/*Table structure for table `edrw_salary` */

DROP TABLE IF EXISTS `edrw_salary`;

CREATE TABLE `edrw_salary` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` varchar(50) DEFAULT NULL,
  `fixed_salary` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `fixed_salary_val` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `fixed_tds_dropdwon` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `hra` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `basic_salary` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `travel` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `other_expenses` varchar(50) DEFAULT NULL,
  `tds_value` varchar(50) DEFAULT NULL,
  `tax` varchar(50) DEFAULT NULL,
  `pan_card` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=DYNAMIC;

/*Data for the table `edrw_salary` */

insert  into `edrw_salary`(`id`,`user_id`,`fixed_salary`,`fixed_salary_val`,`fixed_tds_dropdwon`,`hra`,`basic_salary`,`travel`,`other_expenses`,`tds_value`,`tax`,`pan_card`) values 

(5,'103','1','10000','5',NULL,NULL,NULL,NULL,NULL,NULL,NULL),

(6,'105','0',NULL,NULL,'1','1','1','1','1','1','1');

/*Table structure for table `edrw_section_list` */

DROP TABLE IF EXISTS `edrw_section_list`;

CREATE TABLE `edrw_section_list` (
  `id` int NOT NULL AUTO_INCREMENT,
  `section_id` varchar(50) DEFAULT NULL,
  `class_id` varchar(50) DEFAULT NULL,
  `delete_status` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=205 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

/*Data for the table `edrw_section_list` */

insert  into `edrw_section_list`(`id`,`section_id`,`class_id`,`delete_status`) values 

(203,'17','26',NULL),

(204,'17','27','0');

/*Table structure for table `edrw_session` */

DROP TABLE IF EXISTS `edrw_session`;

CREATE TABLE `edrw_session` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `startdate` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `enddate` varchar(50) DEFAULT NULL,
  `delete_status` varchar(50) DEFAULT NULL,
  `status` int DEFAULT NULL,
  `startMonth` varchar(50) DEFAULT NULL,
  `endMonth` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

/*Data for the table `edrw_session` */

insert  into `edrw_session`(`id`,`name`,`startdate`,`enddate`,`delete_status`,`status`,`startMonth`,`endMonth`) values 

(14,'2020-2021','2020','2020','0',1,'01','01');

/*Table structure for table `edrw_sms_class` */

DROP TABLE IF EXISTS `edrw_sms_class`;

CREATE TABLE `edrw_sms_class` (
  `id` int NOT NULL AUTO_INCREMENT,
  `class` varchar(50) DEFAULT NULL,
  `no_of_period` int DEFAULT NULL,
  `period_duration` int DEFAULT NULL,
  `period_start_time` int DEFAULT NULL,
  `lunch_duration` int DEFAULT NULL,
  `lunch_start_time` int DEFAULT NULL,
  `delete_status` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

/*Data for the table `edrw_sms_class` */

insert  into `edrw_sms_class`(`id`,`class`,`no_of_period`,`period_duration`,`period_start_time`,`lunch_duration`,`lunch_start_time`,`delete_status`) values 

(18,'26',6,1800,1609381800,1800,3,0),

(19,'27',6,1800,1609385400,1800,3,0);

/*Table structure for table `edrw_sms_period` */

DROP TABLE IF EXISTS `edrw_sms_period`;

CREATE TABLE `edrw_sms_period` (
  `id` int NOT NULL AUTO_INCREMENT,
  `period` varchar(50) DEFAULT NULL,
  `start_time` varchar(50) DEFAULT NULL,
  `end_time` varchar(50) DEFAULT NULL,
  `class_id` varchar(50) DEFAULT NULL,
  `class_list_id` varchar(50) DEFAULT NULL,
  `delete_status` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=258 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

/*Data for the table `edrw_sms_period` */

insert  into `edrw_sms_period`(`id`,`period`,`start_time`,`end_time`,`class_id`,`class_list_id`,`delete_status`) values 

(244,'1','1609381800','1609383600','26','18','0'),

(245,'2','1609383600','1609385400','26','18','0'),

(246,'3','1609385400','1609387200','26','18','0'),

(247,'999','1609387200','1609389000','26','18','0'),

(248,'4','1609389000','1609390800','26','18','0'),

(249,'5','1609390800','1609392600','26','18','0'),

(250,'6','1609392600','1609394400','26','18','0'),

(251,'1','1609385400','1609387200','27','19','0'),

(252,'2','1609387200','1609389000','27','19','0'),

(253,'3','1609389000','1609390800','27','19','0'),

(254,'999','1609390800','1609392600','27','19','0'),

(255,'4','1609392600','1609394400','27','19','0'),

(256,'5','1609394400','1609396200','27','19','0'),

(257,'6','1609396200','1609398000','27','19','0');

/*Table structure for table `edrw_student_marks` */

DROP TABLE IF EXISTS `edrw_student_marks`;

CREATE TABLE `edrw_student_marks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `student_id` varchar(50) NOT NULL DEFAULT '0',
  `session_id` varchar(50) NOT NULL DEFAULT '0',
  `exam_id` varchar(50) NOT NULL DEFAULT '0',
  `subject_id` varchar(50) NOT NULL DEFAULT '0',
  `subject_marks` varchar(50) NOT NULL DEFAULT '0',
  `total` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=231 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

/*Data for the table `edrw_student_marks` */

/*Table structure for table `edrw_student_subject` */

DROP TABLE IF EXISTS `edrw_student_subject`;

CREATE TABLE `edrw_student_subject` (
  `id` int NOT NULL AUTO_INCREMENT,
  `student_id` varchar(50) DEFAULT NULL,
  `subject_id` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=179 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

/*Data for the table `edrw_student_subject` */

insert  into `edrw_student_subject`(`id`,`student_id`,`subject_id`) values 

(176,'74','1'),

(177,'74','2'),

(178,'74','3');

/*Table structure for table `edrw_subject_list` */

DROP TABLE IF EXISTS `edrw_subject_list`;

CREATE TABLE `edrw_subject_list` (
  `id` int NOT NULL AUTO_INCREMENT,
  `teacher_id` varchar(50) DEFAULT NULL,
  `subject_id` varchar(50) DEFAULT NULL,
  `delete_status` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=286 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

/*Data for the table `edrw_subject_list` */

insert  into `edrw_subject_list`(`id`,`teacher_id`,`subject_id`,`delete_status`) values 

(282,'103','1','0'),

(283,'105','3','0'),

(284,'107','1','0'),

(285,'107','2','0');

/*Table structure for table `edrw_supplier` */

DROP TABLE IF EXISTS `edrw_supplier`;

CREATE TABLE `edrw_supplier` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;

/*Data for the table `edrw_supplier` */

/*Table structure for table `edrw_teacher_class_section_list` */

DROP TABLE IF EXISTS `edrw_teacher_class_section_list`;

CREATE TABLE `edrw_teacher_class_section_list` (
  `id` int NOT NULL AUTO_INCREMENT,
  `teacher_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `class_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `section_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=DYNAMIC;

/*Data for the table `edrw_teacher_class_section_list` */

insert  into `edrw_teacher_class_section_list`(`id`,`teacher_id`,`class_id`,`section_id`) values 

(12,'107','26','17');

/*Table structure for table `edrw_teacher_list` */

DROP TABLE IF EXISTS `edrw_teacher_list`;

CREATE TABLE `edrw_teacher_list` (
  `id` int NOT NULL AUTO_INCREMENT,
  `teacher_id` varchar(255) DEFAULT NULL,
  `class_id` varchar(255) DEFAULT NULL,
  `delete_status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=394 DEFAULT CHARSET=latin1 ROW_FORMAT=DYNAMIC;

/*Data for the table `edrw_teacher_list` */

insert  into `edrw_teacher_list`(`id`,`teacher_id`,`class_id`,`delete_status`) values 

(391,'103','26',NULL),

(392,'105','26',NULL),

(393,'105','27','0');

/*Table structure for table `edrw_teacher_registration` */

DROP TABLE IF EXISTS `edrw_teacher_registration`;

CREATE TABLE `edrw_teacher_registration` (
  `id` int NOT NULL AUTO_INCREMENT,
  `first_name` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

/*Data for the table `edrw_teacher_registration` */

/*Table structure for table `edrw_temporary_timetable` */

DROP TABLE IF EXISTS `edrw_temporary_timetable`;

CREATE TABLE `edrw_temporary_timetable` (
  `id` int NOT NULL AUTO_INCREMENT,
  `timetable_id` int DEFAULT NULL,
  `period_id` int DEFAULT NULL,
  `week_id` int DEFAULT NULL,
  `teacher_id` int DEFAULT NULL,
  `class_id` int DEFAULT NULL,
  `section_id` int DEFAULT NULL,
  `subject_id` int DEFAULT NULL,
  `start_time` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `end_time` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `leaveList_id` int DEFAULT NULL,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=DYNAMIC;

/*Data for the table `edrw_temporary_timetable` */

/*Table structure for table `edrw_temporary_timetable_history` */

DROP TABLE IF EXISTS `edrw_temporary_timetable_history`;

CREATE TABLE `edrw_temporary_timetable_history` (
  `id` int NOT NULL AUTO_INCREMENT,
  `timetable_id` int DEFAULT NULL,
  `period_id` int DEFAULT NULL,
  `week_id` int DEFAULT NULL,
  `teacher_id` int DEFAULT NULL,
  `class_id` int DEFAULT NULL,
  `section_id` int DEFAULT NULL,
  `subject_id` int DEFAULT NULL,
  `start_time` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `end_time` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `leaveList_id` int DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=DYNAMIC;

/*Data for the table `edrw_temporary_timetable_history` */

/*Table structure for table `edrw_tenant` */

DROP TABLE IF EXISTS `edrw_tenant`;

CREATE TABLE `edrw_tenant` (
  `id` int NOT NULL AUTO_INCREMENT,
  `tenant_name` varchar(20) DEFAULT NULL,
  `user_name` varchar(50) DEFAULT NULL,
  `password` varchar(50) DEFAULT NULL,
  `delete_status` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

/*Data for the table `edrw_tenant` */


/*Table structure for table `edrw_timetable` */

DROP TABLE IF EXISTS `edrw_timetable`;

CREATE TABLE `edrw_timetable` (
  `id` int NOT NULL AUTO_INCREMENT,
  `period_id` int DEFAULT NULL,
  `week_id` int DEFAULT NULL,
  `teacher_id` int DEFAULT NULL,
  `class_id` int DEFAULT NULL,
  `section_id` int DEFAULT NULL,
  `subject_id` int DEFAULT NULL,
  `start_time` int DEFAULT NULL,
  `end_time` int DEFAULT NULL,
  `adjustment` int DEFAULT NULL,
  `custom_table_id` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=318 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

/*Data for the table `edrw_timetable` */

insert  into `edrw_timetable`(`id`,`period_id`,`week_id`,`teacher_id`,`class_id`,`section_id`,`subject_id`,`start_time`,`end_time`,`adjustment`,`custom_table_id`) values 

(316,244,1,103,26,17,1,1609381800,1609383600,0,NULL),

(317,247,1,105,26,17,3,1609387200,1609389000,0,NULL);

/*Table structure for table `edrw_upload_document` */

DROP TABLE IF EXISTS `edrw_upload_document`;

CREATE TABLE `edrw_upload_document` (
  `id` int NOT NULL AUTO_INCREMENT,
  `color_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `logo_name` varchar(5000) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `logo_path` varchar(5000) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `favicon_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `favicon_path` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

/*Data for the table `edrw_upload_document` */

insert  into `edrw_upload_document`(`id`,`color_name`,`logo_name`,`logo_path`,`favicon_name`,`favicon_path`) values 

(1,'#042340','1609422947_7536492c1242de5a17d7.jpg','logo_and_favicon/1609422947_7536492c1242de5a17d7.jpg','1609423039_80c69d1f6ebb74f51097.png','logo_and_favicon/1609423039_80c69d1f6ebb74f51097.png');

/*Table structure for table `edrw_uploadimage` */

DROP TABLE IF EXISTS `edrw_uploadimage`;

CREATE TABLE `edrw_uploadimage` (
  `id` int NOT NULL AUTO_INCREMENT,
  `file_name` varchar(50) DEFAULT NULL,
  `file_path` varchar(50) DEFAULT NULL,
  `std_id` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=53 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

/*Data for the table `edrw_uploadimage` */

/*Table structure for table `edrw_user_attendance` */

DROP TABLE IF EXISTS `edrw_user_attendance`;

CREATE TABLE `edrw_user_attendance` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `date` varchar(255) DEFAULT NULL,
  `attendance_status` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `role_id` int DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1233 DEFAULT CHARSET=latin1 ROW_FORMAT=DYNAMIC;

/*Data for the table `edrw_user_attendance` */

insert  into `edrw_user_attendance`(`id`,`user_id`,`date`,`attendance_status`,`role_id`) values 

(1231,'103','1609353000','10',46),

(1232,'105','1609353000','11',46);

/*Table structure for table `edrw_user_permission` */

DROP TABLE IF EXISTS `edrw_user_permission`;

CREATE TABLE `edrw_user_permission` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT '0',
  `permission_id` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT '0',
  `status` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=57 DEFAULT CHARSET=latin1 ROW_FORMAT=DYNAMIC;

/*Data for the table `edrw_user_permission` */

/*Table structure for table `edrw_users` */
CREATE TABLE `edrw_attendance_type` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `status` varchar(50) DEFAULT NULL,
  `delete_status` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=latin1 ROW_FORMAT=DYNAMIC;

/*Data for the table `edrw_attendance_type` */

insert  into `edrw_attendance_type`(`id`,`name`,`status`,`delete_status`) values 

(1,'present','1','0'),

(2,'absent','1','0'),

(3,'leave','1','0'),

(4,'summer vacation','1','0'),

(5,'winter vacation','1','0'),

(6,'boot camp','1','0'),

(7,'bio-metric','1','1'),

(8,'shd','1','1'),

(9,'bio-metric','1','0');

DROP TABLE IF EXISTS `edrw_users`;

CREATE TABLE `edrw_users` (
  `id` int NOT NULL AUTO_INCREMENT,
  `uname` varchar(255) DEFAULT NULL,
  `firstname` varchar(255) NOT NULL,
  `lastname` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `password` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `subject_name` varchar(255) NOT NULL,
  `std_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  FULLTEXT KEY `firstname` (`firstname`,`email`)
) ENGINE=InnoDB AUTO_INCREMENT=110 DEFAULT CHARSET=latin1;

/*Data for the table `edrw_users` */

insert  into `edrw_users`(`id`,`uname`,`firstname`,`lastname`,`email`,`password`,`status`,`subject_name`,`std_id`) values 
(1,'admin','admin','admin','admin','ab233b682ec355648e7891e66c54191b','1','test','1');

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;
insert  into `edrw_users`(`id`,`uname`,`firstname`,`lastname`,`email`,`password`,`status`,`subject_name`,`std_id`) values 
(2,'rtg','Tenant','admin','admin@admin.com','0de8a52d989a4042dc225eb388d3fca7','1','test','1');