"use strict";

function Calendar(e, t, n, i, a) {
    this.id = e, this.size = t, this.labelSettings = n, this.colors = i, this.initday = 0, a = a || {}, this.indicator = !0, null != a.indicator && (this.indicator = a.indicator), this.indicator_type = 1, null != a.indicator_type && (this.indicator_type = a.indicator_type), this.indicator_pos = 1 == this.indicator_type ? "bottom" : "top", null != a.indicator_pos && (this.indicator_pos = a.indicator_pos);
    var d = document.createElement("LI");
    d.className = "cjslib-list-placeholder", d.appendChild(document.createTextNode("No events on this day")), d.style = "text-align: center; padding: 20px 0px;", this.placeholder = d.outerHTML, null != a.placeholder && (this.placeholder = a.placeholder);
    var o = ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
    null != a.months && 12 == a.months.length && (o = a.months);
    var l = ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
    null != a.days && 7 == a.days.length && (l = a.days), this.months = o, this.defaultLabels = l, this.label = [], this.labels = [];
    for (var s = 0; s < 7; s++) this.label.push(l[l.indexOf(n[0]) + this.label.length >= l.length ? Math.abs(l.length - (l.indexOf(n[0]) + this.label.length)) : l.indexOf(n[0]) + this.label.length]);
    for (s = 0; s < 7; s++) this.labels.push(this.label[s].substring(0, 3 < n[1] ? 3 : n[1]));
    this.date = new Date, this.today = new Date, this.history = [], this.draw(), this.update(), this.setOnClickListener("days-blocks"), this.setOnClickListener("month-slider"), this.setOnClickListener("year-slider")
}

function Organizer(e, t, n) {
    this.id = e, this.calendar = t, this.data = n || {}, this.draw();
    var i = this;
    i.onMonthChange(function() {
        i.indicateEvents()
    }), this.setOnClickListener("days-blocks"), this.setOnClickListener("day-slider"), this.setOnClickListener("month-slider"), this.setOnClickListener("year-slider"), this.setOnLongClickListener("days-blocks")
}
Calendar.prototype = {
    constructor: Calendar,
    back: function(e) {
        var t = this.date,
            n = (new Date(11 < t.getMonth() + 1 ? t.getFullYear() + 1 : t.getFullYear(), 12 < t.getMonth() + 1 ? 0 : t.getMonth() + 1, 0).getDate(), new Date(t.getMonth() < 0 ? t.getFullYear() - 1 : t.getFullYear(), t.getMonth() < 0 ? 11 : t.getMonth(), 0).getDate());
        "month" == e ? (t.getDate() > n && this.changeDateTo(n), 0 < t.getMonth() ? t.setMonth(t.getMonth() - 1) : (t.setMonth(11), t.setFullYear(t.getFullYear() - 1))) : "year" == e && t.setFullYear(t.getFullYear() - 1), this.update()
    },
    next: function(e) {
        var t = this.date,
            n = (new Date(11 < t.getMonth() + 1 ? t.getFullYear() + 1 : t.getFullYear(), 12 < t.getMonth() + 1 ? 0 : t.getMonth() + 1, 0).getDate(), new Date(11 < t.getMonth() + 2 ? t.getFullYear() + 1 : t.getFullYear(), 12 < t.getMonth() + 2 ? 0 : t.getMonth() + 2, 0).getDate());
        "month" == e ? (t.getDate() > n && this.changeDateTo(n), 11 != t.getMonth() ? t.setMonth(t.getMonth() + 1) : (t.setMonth(0), t.setFullYear(t.getFullYear() + 1))) : t.setFullYear(t.getFullYear() + 1), this.update()
    },
    changeDateTo: function(e, t) {
        if (31 <= t && e <= 11 || t <= 6 && 8 <= e) {
            31 <= t && e <= 11 ? this.next("month") : t <= 6 && 8 <= e && this.back("month"), this.date.setDate(e);
            var n = this;
            return setTimeout(function() {
                n.update()
            }, 1), !0
        }
        this.date.setDate(e)
    },
    getDateString: function() {
        return this.months[this.date.getMonth()] + " " + this.date.getDate() + ", " + this.date.getFullYear()
    }
}, Calendar.prototype.draw = function() {
    var e = '<svg style="width: 24px; height: 24px;" viewBox="0 0 24 24"><path fill="' + this.colors[3] + '" d="M15.41,16.58L10.83,12L15.41,7.41L14,6L8,12L14,18L15.41,16.58Z"></path></svg>',
        t = '<svg style="width: 24px; height: 24px;" viewBox="0 0 24 24"><path fill="' + this.colors[3] + '" d="M8.59,16.58L13.17,12L8.59,7.41L10,6L16,12L10,18L8.59,16.58Z"></path></svg>',
        n = document.createElement("DIV");
    n.className = "cjslib-calendar cjslib-size-" + this.size, document.getElementById(this.id).appendChild(n.cloneNode(!0));
    for (var i = [], a = ["year", "month", "labels", "days"], d = 0; d < a.length; d++) {
        var o, l;
        if (i[d] = document.createElement("DIV"), i[d].className = "cjslib-" + a[d], "days" != a[d])
            if ("month" != a[d]) {
                if (i[d].style.backgroundColor = this.colors[1], i[d].style.color = this.colors[3], "labels" != a[d])(o = document.createElement("DIV")).id = this.id + "-year-back", o.insertAdjacentHTML("beforeend", e), i[d].appendChild(o.cloneNode(!0)), (m = document.createElement("SPAN")).id = this.id + "-" + a[d], i[d].appendChild(m.cloneNode(!0)), (l = document.createElement("DIV")).id = this.id + "-year-next", l.insertAdjacentHTML("beforeend", t), i[d].appendChild(l.cloneNode(!0))
            } else i[d].style.backgroundColor = this.colors[0], i[d].style.color = this.colors[2], (o = document.createElement("DIV")).id = this.id + "-month-back", o.insertAdjacentHTML("beforeend", e), i[d].appendChild(o.cloneNode(!0)), (m = document.createElement("SPAN")).id = this.id + "-" + a[d], i[d].appendChild(m.cloneNode(!0)), (l = document.createElement("DIV")).id = this.id + "-month-next", l.insertAdjacentHTML("beforeend", t), i[d].appendChild(l.cloneNode(!0))
    }
    for (d = 0; d < this.labels.length; d++) {
        var s = document.createElement("SPAN");
        s.id = this.id + "-label-" + (d + 1), s.appendChild(document.createTextNode(this.labels[d]).cloneNode(!0)), i[2].appendChild(s.cloneNode(!0))
    }
    var c = [],
        r = [],
        h = [];
    for (d = 0; d < 6; d++) c[d] = document.createElement("DIV"), c[d].className = "cjslib-row";
    d = 0;
    for (var u = 0; d < 42; d++) {
        var m;
        if (h[d] = document.createElement("INPUT"), h[d].className = "cjslib-day-radios", h[d].type = "radio", h[d].name = this.id + "-day-radios", h[d].id = this.id + "-day-radio-" + (d + 1), r[d] = document.createElement("LABEL"), r[d].className = "cjslib-day", r[d].htmlFor = this.id + "-day-radio-" + (d + 1), r[d].id = this.id + "-day-" + (d + 1), (m = document.createElement("SPAN")).className = "cjslib-day-num", m.id = this.id + "-day-num-" + (d + 1), r[d].appendChild(m.cloneNode(!0)), this.indicator) {
            var g = document.createElement("SPAN");
            g.className = "cjslib-day-indicator cjslib-indicator-pos-" + this.indicator_pos, 1 == this.indicator_type && (g.className += " cjslib-indicator-type-numeric"), g.id = this.id + "-day-indicator-" + (d + 1), r[d].appendChild(g.cloneNode(!0))
        }
        c[u].appendChild(h[d].cloneNode(!0)), c[u].appendChild(r[d].cloneNode(!0)), (d + 1) % 7 == 0 && u++
    }
    for (d = 0; d < 6; d++) i[3].appendChild(c[d].cloneNode(!0));
    for (d = 0; d < i.length; d++) n.appendChild(i[d].cloneNode(!0));
    document.getElementById(this.id).innerHTML = "<style>.cjslib-day-indicator { color: " + this.colors[1] + "; background-color: " + this.colors[1] + "; } .cjslib-indicator-type-numeric { color: " + this.colors[2] + "; } .cjslib-day.cjslib-day-today > .cjslib-day-num { border-color: " + this.colors[1] + " !important; }</style>", document.getElementById(this.id).appendChild(n.cloneNode(!0))
}, Calendar.prototype.update = function() {
    document.getElementById(this.id + "-year").innerHTML = this.date.getFullYear(), document.getElementById(this.id + "-month").innerHTML = this.months[this.date.getMonth()];
    for (var e = 1; e <= 42; e++) document.getElementById(this.id + "-day-num-" + e).innerHTML = "", document.getElementById(this.id + "-day-" + e).className = this.id + " cjslib-day cjslib-day-listed";
    var t = new Date(this.date.getFullYear(), this.date.getMonth(), 1).getDay(),
        n = new Date(11 < this.date.getMonth() + 1 ? this.date.getFullYear() + 1 : this.date.getFullYear(), 12 < this.date.getMonth() + 1 ? 0 : this.date.getMonth() + 1, 0).getDate(),
        i = new Date(this.date.getMonth() < 0 ? this.date.getFullYear() - 1 : this.date.getFullYear(), this.date.getMonth() < 0 ? 11 : this.date.getMonth(), 0).getDate();
    this.initday = this.label.indexOf(this.defaultLabels[t]);
    for (var a = this.defaultLabels[t], d = this.label.indexOf(a), o = (e = 0, i); e < d; e++, o--) document.getElementById(this.id + "-day-num-" + (d - e)).innerHTML = o, document.getElementById(this.id + "-day-" + (d - e)).className = this.id + " cjslib-day cjslib-day-diluted";
    for (e = 1; e <= n; e++)(document.getElementById(this.id + "-day-num-" + (d + e)).innerHTML = e) == this.date.getDate() && (document.getElementById(this.id + "-day-radio-" + (d + e)).checked = !0), this.date.getMonth() == this.today.getMonth() && e == this.today.getDate() && (document.getElementById(this.id + "-day-" + (d + e)).className += " cjslib-day-today");
    for (e = n + 1, o = 1; d + e <= 42; e++, o++) document.getElementById(this.id + "-day-num-" + (d + e)).innerHTML = o, document.getElementById(this.id + "-day-" + (d + e)).className = this.id + " cjslib-day cjslib-day-diluted"
}, Calendar.prototype.setupBlock = function(e, t, n) {
    document.getElementById(t.id + "-day-" + e).onclick = function() {
        0 < document.getElementById(t.id + "-day-num-" + e).innerHTML.length && (t.changeDateTo(document.getElementById(t.id + "-day-num-" + e).innerHTML, e), n())
    }
}, Calendar.prototype.setOnClickListener = function(e, t, n) {
    var i = this.id;
    t = t || function() {}, n = n || function() {};
    var a = this;
    switch (e) {
        case "days-blocks":
            for (var d = 1; d <= 42; d++) a.setupBlock(d, a, t);
            break;
        case "month-slider":
            document.getElementById(i + "-month-back").onclick = function() {
                a.back("month"), t()
            }, document.getElementById(i + "-month-next").onclick = function() {
                a.next("month"), n()
            };
            break;
        case "year-slider":
            document.getElementById(i + "-year-back").onclick = function() {
                a.back("year"), t()
            }, document.getElementById(i + "-year-next").onclick = function() {
                a.next("year"), n()
            }
    }
}, Organizer.prototype = {
    constructor: Organizer,
    back: function(e) {
        var t = this.calendar.date,
            n = new Date(11 < t.getMonth() + 1 ? t.getFullYear() + 1 : t.getFullYear(), 12 < t.getMonth() + 1 ? 0 : t.getMonth() + 1, 0).getDate();
        new Date(t.getMonth() < 0 ? t.getFullYear() - 1 : t.getFullYear(), t.getMonth() < 0 ? 11 : t.getMonth(), 0).getDate();
        if ("day" == e) {
            if (1 != t.getDate()) this.changeDateTo(t.getDate() - 1), this.update();
            else this.calendar.back("month"), this.changeDateTo(n), (i = this).onMonthChange(function() {
                i.indicateEvents()
            });
            document.getElementById(this.calendar.id + "-day-radio-" + (this.calendar.initday + t.getDate())).checked = !0
        } else {
            var i;
            this.calendar.back(e), (i = this).onMonthChange(function() {
                i.indicateEvents()
            })
        }
    },
    next: function(e) {
        var t = this.calendar.date,
            n = new Date(11 < t.getMonth() + 1 ? t.getFullYear() + 1 : t.getFullYear(), 12 < t.getMonth() + 1 ? 0 : t.getMonth() + 1, 0).getDate();
        new Date(11 < t.getMonth() + 2 ? t.getFullYear() + 1 : t.getFullYear(), 12 < t.getMonth() + 2 ? 0 : t.getMonth() + 2, 0).getDate();
        if ("day" == e) {
            if (t.getDate() != n) t.setDate(t.getDate() + 1), this.update();
            else this.calendar.next("month"), t.setDate(1), (i = this).onMonthChange(function() {
                i.indicateEvents()
            });
            document.getElementById(this.calendar.id + "-day-radio-" + (this.calendar.initday + t.getDate())).checked = !0

        } else {
            var i;
            this.calendar.next(e), (i = this).onMonthChange(function() {
                i.indicateEvents()
            })
        }
    },
    changeDateTo: function(e, t) {
        this.clearHistory();
        var n = this.calendar.changeDateTo(e, t),
            i = this;
        setTimeout(function() {
            n ? i.onMonthChange(function() {
                i.indicateEvents()
            }) : i.update()
        }, 1)
    },
    addDate: function(e, t) {
        this.showHistory();
        var n = this.calendar.changeDateTo(e, t),
            i = this;
        setTimeout(function() {
            n ? i.onMonthChange(function() {
                i.indicateEvents()
            }) : i.update()
        }, 1)
    }
}, Organizer.prototype.draw = function() {
    var e = '<svg style="width: 24px; height: 24px;" viewBox="0 0 24 24"><path fill="' + this.calendar.colors[3] + '" d="M15.41,16.58L10.83,12L15.41,7.41L14,6L8,12L14,18L15.41,16.58Z"></path></svg>',
        t = '<svg style="width: 24px; height: 24px;" viewBox="0 0 24 24"><path fill="' + this.calendar.colors[3] + '" d="M8.59,16.58L13.17,12L8.59,7.41L10,6L16,12L10,18L8.59,16.58Z"></path></svg>',
        n = document.createElement("DIV");
    n.className = "cjslib-events cjslib-size-" + this.calendar.size;
    var i = document.createElement("DIV");
    i.className = "cjslib-date", i.style.backgroundColor = this.calendar.colors[1], i.style.color = this.calendar.colors[3];
    var a = document.createElement("DIV");
    a.id = this.id + "-day-back", a.insertAdjacentHTML("beforeend", e), i.appendChild(a.cloneNode(!0));
    var d = document.createElement("SPAN");
    d.id = this.id + "-date", i.appendChild(d.cloneNode(!0));
    var o = document.createElement("DIV");
    o.id = this.id + "-day-next", o.insertAdjacentHTML("beforeend", t), i.appendChild(o.cloneNode(!0));
    var l = document.createElement("DIV");
    l.className = "cjslib-rows", l.id = this.id + "-list-container";
    var s = document.createElement("OL");
    s.className = "cjslib-list", s.id = this.id + "-list";
    var c = document.createElement("OL");
    c.className = "cjslib-list", c.id = this.id + "-history", l.appendChild(s.cloneNode(!0)), l.appendChild(c.cloneNode(!0)), n.appendChild(i.cloneNode(!0)), n.appendChild(l.cloneNode(!0)), document.getElementById(this.id).appendChild(n.cloneNode(!0))
}, Organizer.prototype.update = function() {
    document.getElementById(this.id + "-date").innerHTML = this.calendar.months[this.calendar.date.getMonth()] + " " + this.calendar.date.getDate() + ", " + this.calendar.date.getFullYear(), document.getElementById(this.id + "-list").innerHTML = "", this.showEvents()
}, Organizer.prototype.updateData = function(e) {
    this.data = e, this.indicateEvents(), this.update()
}, Organizer.prototype.list = function(e) {
    for (var t = document.createElement("UL"), n = 0; n < e.length; n++) {
        var i = document.createElement("LI");
        i.id = this.id + "-list-item-" + n;
        var a = document.createElement("DIV"),
            d = document.createElement("SPAN");
        d.id = this.id + "-list-item-" + n + "-time", d.class = this.id + " time", d.appendChild(document.createTextNode(e[n].startTime + " - " + e[n].endTime)), a.appendChild(d);
        var o = document.createElement("P");
        o.id = this.id + "-list-item-" + n + "-text";
        var l = document.createTextNode(e[n].text);
        if (null == e[n].link || "" == e[n].link) o.appendChild(l);
        else {
            var s = document.createElement("A");
            s.href = e[n].link, s.target = "_blank", s.class = this.id + " link", s.appendChild(l), o.appendChild(s)
        }
        i.appendChild(a), i.appendChild(o), t.appendChild(i)
    }
    return t.innerHTML
}, Organizer.prototype.remember = function(e, t) {
    if (t.startsWith('<div class="cjslib-list-placeholder">')) return "";
    var n = this.calendar.getDateString();
    this.calendar.history.unshift(n);
    var i = document.createElement("UL");
    i.className = "cjslib-list cjslib-list-history";
    var a = document.createElement("LI");
    return a.appendChild(document.createTextNode(n)), a.className = "cjslib-list-history-title cjslib-date", a.style.backgroundColor = this.calendar.colors[1], a.style.color = this.calendar.colors[3], i.appendChild(a), i.innerHTML += t, i.outerHTML
}, Organizer.prototype.clearHistory = function() {
    this.calendar.history = [], document.getElementById(this.id + "-history").innerHTML = ""
}, Organizer.prototype.setupBlock = function(t, n, i) {
    var a = n.calendar;
    document.getElementById(a.id + "-day-" + t).onclick = function() {
        if (0 < document.getElementById(a.id + "-day-num-" + t).innerHTML.length) {
            if (document.getElementById(a.id + "-day-radio-" + t).checked) return;
            var e = "" + document.getElementById(a.id + "-day-num-" + t).dataset.longpressed;
            document.getElementById(a.id + "-day-num-" + t).dataset.longpressed = !1, "true" != e && (n.changeDateTo(document.getElementById(a.id + "-day-num-" + t).innerHTML, t), i())
        }
    }
}, Organizer.prototype.showEvents = function(e) {
    e = e || this.data;
    var t = this.calendar.date,
        n = "",
        i = "";
    try {
        var a = this.calendar.history.indexOf(this.calendar.getDateString()); - 1 < a && (this.calendar.history.splice(a, 1), document.getElementById(this.id + "-history").children[a].remove()), i += i + document.getElementById(this.id + "-list").innerHTML, n = this.list(e[t.getFullYear()][t.getMonth() + 1][t.getDate()])
    } catch (e) {
        n = this.showPlaceholder()
    }
    document.getElementById(this.id + "-list").innerHTML = n
}, Organizer.prototype.showHistory = function(e) {
    e = e || this.data;
    var t = this.calendar.date,
        n = this.remember(t, document.getElementById(this.id + "-list").innerHTML),
        i = document.getElementById(this.id + "-history").innerHTML;
    document.getElementById(this.id + "-history").innerHTML = n + i
}, Organizer.prototype.showPlaceholder = function(e) {
    var t = document.createElement("DIV");
    return t.className = "cjslib-list-placeholder", t.innerHTML = this.calendar.placeholder, t.outerHTML
}, Organizer.prototype.indicateEvents = function(e) {
    e = e || this.data;
    var t = this.calendar.date;
    if (this.calendar.indicator) {
        for (var n = document.getElementsByClassName(this.calendar.id + " cjslib-day cjslib-day-listed"), i = 0; i < n.length; i++) n[i].children[1].innerHTML = "";
        try {
            var a = e[t.getFullYear()][t.getMonth() + 1];
            for (var d in a) 0 < a[d].length && (n[d - 1].children[1].innerHTML = 9 < a[d].length ? "9+" : a[d].length)
        } catch (e) {}
    }
    this.update()
}, Organizer.prototype.onMonthChange = function(e) {
    e()
}, Organizer.prototype.setOnClickListener = function(e, t, n) {
    var i = this.calendar.id,
        a = this.id;
    t = t || function() {}, n = n || function() {};
    var d = this;
    switch (e) {
        case "days-blocks":
            for (var o = 1; o <= 42; o++) d.setupBlock(o, d, t);
            break;
        case "day-slider":
            document.getElementById(a + "-day-back").onclick = function() {
                d.back("day"), t()
            }, document.getElementById(a + "-day-next").onclick = function() {
                d.next("day"), n()
            };
            break;
        case "month-slider":
            document.getElementById(i + "-month-back").onclick = function() {
                d.back("month"), t()
            }, document.getElementById(i + "-month-next").onclick = function() {
                d.next("month"), n()
            };
            break;
        case "year-slider":
            document.getElementById(i + "-year-back").onclick = function() {
                d.back("year"), t()
            }, document.getElementById(i + "-year-next").onclick = function() {
                d.next("year"), n()
            }
    }
}, Organizer.prototype.setupLongClickBlock = function(e, t, n) {
    function i() {
        document.getElementById(a.id + "-day-num-" + e).dataset.longpressed = "-", window.setTimeout(function() {
            if (0 < document.getElementById(a.id + "-day-num-" + e).innerHTML.length) {
                if ("false" == document.getElementById(a.id + "-day-num-" + e).dataset.longpressed) return;
                if (document.getElementById(a.id + "-day-num-" + e).dataset.longpressed = !0, document.getElementById(a.id + "-day-radio-" + e).checked) return;
                t.addDate(document.getElementById(a.id + "-day-num-" + e).innerHTML, e), n()
            }
        }, 1e3)
    }
    var a = t.calendar;
    document.getElementById(a.id + "-day-" + e).onmousedown = i, document.getElementById(a.id + "-day-" + e).ontouchstart = i
}, Organizer.prototype.setOnLongClickListener = function(e, t, n) {
    this.calendar.id, this.id;
    t = t || function() {};
    switch (e) {
        case "days-blocks":
            for (var i = 1; i <= 42; i++) this.setupLongClickBlock(i, this, t)
    }
};