USE `labz_sms`;



CREATE TABLE `tiphunzire_Event` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `description_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `startdate` varchar(50) DEFAULT NULL,
  `enddate` varchar(50) DEFAULT NULL,
  `amount` varchar(100) DEFAULT NULL,
  `delete_status` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

/*Table structure for table `tiphunzire_accounting` */

DROP TABLE IF EXISTS `tiphunzire_accounting`;

CREATE TABLE `tiphunzire_accounting` (
  `id` int NOT NULL AUTO_INCREMENT,
  `date` varchar(50) DEFAULT NULL,
  `particular` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `vch_number` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `vch_type` varchar(50) DEFAULT NULL,
  `salary_type` varchar(50) DEFAULT NULL,
  `amount` varchar(50) DEFAULT NULL,
  `user_id` varchar(50) DEFAULT NULL,
  `delete_status` int DEFAULT NULL,
  `student` enum('yes','no') DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=DYNAMIC;

/*Table structure for table `tiphunzire_add_class` */

DROP TABLE IF EXISTS `tiphunzire_add_class`;

CREATE TABLE `tiphunzire_add_class` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `delete_status` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=63 DEFAULT CHARSET=latin1 ROW_FORMAT=DYNAMIC;

/*Table structure for table `tiphunzire_add_field` */

DROP TABLE IF EXISTS `tiphunzire_add_field`;

CREATE TABLE `tiphunzire_add_field` (
  `id` int NOT NULL AUTO_INCREMENT,
  `field_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `field_type` varchar(100) DEFAULT NULL,
  `default_value` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `required` enum('yes','no') DEFAULT NULL,
  `form_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

/*Table structure for table `tiphunzire_add_section` */

DROP TABLE IF EXISTS `tiphunzire_add_section`;

CREATE TABLE `tiphunzire_add_section` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=latin1 ROW_FORMAT=DYNAMIC;

/*Table structure for table `tiphunzire_add_subject` */

DROP TABLE IF EXISTS `tiphunzire_add_subject`;

CREATE TABLE `tiphunzire_add_subject` (
  `id` int NOT NULL AUTO_INCREMENT,
  `subject_name` varchar(50) DEFAULT NULL,
  `delete_status` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

/*Table structure for table `tiphunzire_address2` */

DROP TABLE IF EXISTS `tiphunzire_address2`;

CREATE TABLE `tiphunzire_address2` (
  `id` int NOT NULL AUTO_INCREMENT,
  `address1` text,
  `address2` text,
  `zip_code` varchar(50) DEFAULT NULL,
  `state` varchar(50) DEFAULT NULL,
  `city` varchar(50) DEFAULT NULL,
  `country` varchar(50) DEFAULT NULL,
  `sid` int DEFAULT NULL,
  `type` enum('admin','student') DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=35 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

/*Table structure for table `tiphunzire_advance_salary` */

DROP TABLE IF EXISTS `tiphunzire_advance_salary`;

CREATE TABLE `tiphunzire_advance_salary` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` int DEFAULT NULL,
  `amount` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `description` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `delete_status` int DEFAULT NULL,
  `status` enum('pending','accepted','rejected','adjusted') DEFAULT NULL,
  `created_date` varchar(100) DEFAULT NULL,
  `updated_date` varchar(100) DEFAULT NULL,
  `salary_id` int DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=DYNAMIC;

/*Table structure for table `tiphunzire_attendance_type` */

DROP TABLE IF EXISTS `tiphunzire_attendance_type`;

CREATE TABLE `tiphunzire_attendance_type` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `status` varchar(50) DEFAULT NULL,
  `delete_status` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=latin1 ROW_FORMAT=DYNAMIC;

/*Table structure for table `tiphunzire_class_and_section_list` */

DROP TABLE IF EXISTS `tiphunzire_class_and_section_list`;

CREATE TABLE `tiphunzire_class_and_section_list` (
  `id` int NOT NULL AUTO_INCREMENT,
  `student_id` int DEFAULT NULL,
  `class_id` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `section_id` varchar(50) DEFAULT NULL,
  `session_id` varchar(50) DEFAULT NULL,
  `delete_status` int DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=185 DEFAULT CHARSET=latin1 ROW_FORMAT=DYNAMIC;

/*Table structure for table `tiphunzire_class_fee` */

DROP TABLE IF EXISTS `tiphunzire_class_fee`;

CREATE TABLE `tiphunzire_class_fee` (
  `id` int NOT NULL AUTO_INCREMENT,
  `class_id` varchar(50) DEFAULT NULL,
  `admission_fee` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `registration_fee` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `transportation_fee` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `tuition_fee` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `total_fee` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `apply_date` int DEFAULT NULL,
  `duration` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=DYNAMIC;

/*Table structure for table `tiphunzire_class_subject` */

DROP TABLE IF EXISTS `tiphunzire_class_subject`;

CREATE TABLE `tiphunzire_class_subject` (
  `id` int NOT NULL AUTO_INCREMENT,
  `class_id` varchar(50) DEFAULT NULL,
  `subject_id` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=621 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

/*Table structure for table `tiphunzire_class_teacher_list` */

DROP TABLE IF EXISTS `tiphunzire_class_teacher_list`;

CREATE TABLE `tiphunzire_class_teacher_list` (
  `id` int NOT NULL AUTO_INCREMENT,
  `teacher_id` varchar(50) DEFAULT NULL,
  `class_id` varchar(50) DEFAULT NULL,
  `delete_status` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

/*Table structure for table `tiphunzire_custom_event` */

DROP TABLE IF EXISTS `tiphunzire_custom_event`;

CREATE TABLE `tiphunzire_custom_event` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `startdate` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `enddate` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `amount` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `delete_status` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `user_id` int DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=DYNAMIC;

/*Table structure for table `tiphunzire_custom_lecture_request` */

DROP TABLE IF EXISTS `tiphunzire_custom_lecture_request`;

CREATE TABLE `tiphunzire_custom_lecture_request` (
  `id` int NOT NULL AUTO_INCREMENT,
  `custom_timetable_id` int DEFAULT NULL,
  `teacher_id` int DEFAULT NULL,
  `status` enum('pending','accepted','rejected') DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

/*Table structure for table `tiphunzire_custom_timetable` */

DROP TABLE IF EXISTS `tiphunzire_custom_timetable`;

CREATE TABLE `tiphunzire_custom_timetable` (
  `id` int NOT NULL AUTO_INCREMENT,
  `timetable_id` int DEFAULT NULL,
  `period_id` int DEFAULT NULL,
  `week_id` int DEFAULT NULL,
  `teacher_id` int DEFAULT NULL,
  `class_id` int DEFAULT NULL,
  `section_id` int DEFAULT NULL,
  `subject_id` int DEFAULT NULL,
  `start_time` varchar(50) DEFAULT NULL,
  `end_time` varchar(50) DEFAULT NULL,
  `adjustment_duration` varchar(50) DEFAULT NULL,
  `addStartDate` varchar(50) DEFAULT NULL,
  `addEndDate` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=DYNAMIC;

/*Table structure for table `tiphunzire_emi` */

DROP TABLE IF EXISTS `tiphunzire_emi`;

CREATE TABLE `tiphunzire_emi` (
  `id` int NOT NULL AUTO_INCREMENT,
  `loan_id` int DEFAULT NULL,
  `month` varchar(100) DEFAULT NULL,
  `emi_number` int DEFAULT NULL,
  `status` varchar(50) DEFAULT NULL,
  `updated_date` varchar(100) DEFAULT NULL,
  `created_date` varchar(100) DEFAULT NULL,
  `salary_id` varchar(100) DEFAULT NULL,
  `interest` varchar(100) DEFAULT NULL,
  `emi_amount` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `delete_status` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

/*Table structure for table `tiphunzire_employee_image` */

DROP TABLE IF EXISTS `tiphunzire_employee_image`;

CREATE TABLE `tiphunzire_employee_image` (
  `id` int NOT NULL AUTO_INCREMENT,
  `file_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `file_path` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `user_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=DYNAMIC;

/*Table structure for table `tiphunzire_employee_order` */

DROP TABLE IF EXISTS `tiphunzire_employee_order`;

CREATE TABLE `tiphunzire_employee_order` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `status` varchar(10) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `order_id` int DEFAULT NULL,
  `location` enum('front','back') CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `field_name` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `show_name` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1 ROW_FORMAT=DYNAMIC;

/*Table structure for table `tiphunzire_exam` */

DROP TABLE IF EXISTS `tiphunzire_exam`;

CREATE TABLE `tiphunzire_exam` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `delete_status` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

/*Table structure for table `tiphunzire_fees` */

DROP TABLE IF EXISTS `tiphunzire_fees`;

CREATE TABLE `tiphunzire_fees` (
  `id` int NOT NULL AUTO_INCREMENT,
  `admission_fee` varchar(50) DEFAULT NULL,
  `registration_fee` varchar(50) DEFAULT NULL,
  `transportation_fee` varchar(50) DEFAULT NULL,
  `tuition_fee` varchar(50) DEFAULT NULL,
  `total_fee` varchar(50) DEFAULT NULL,
  `sid` varchar(50) DEFAULT NULL,
  `from_date` varchar(50) DEFAULT NULL,
  `to_date` varchar(50) DEFAULT NULL,
  `paid` enum('yes','no') DEFAULT NULL,
  `duration` varchar(50) DEFAULT NULL,
  `delete_status` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=52 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

/*Table structure for table `tiphunzire_field_value` */

DROP TABLE IF EXISTS `tiphunzire_field_value`;

CREATE TABLE `tiphunzire_field_value` (
  `id` int NOT NULL AUTO_INCREMENT,
  `reference_id` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `field_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `field_value` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=98 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin;

/*Table structure for table `tiphunzire_holiday` */

DROP TABLE IF EXISTS `tiphunzire_holiday`;

CREATE TABLE `tiphunzire_holiday` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `startdate` varchar(50) DEFAULT NULL,
  `enddate` varchar(50) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `delete_status` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

/*Table structure for table `tiphunzire_island` */

DROP TABLE IF EXISTS `tiphunzire_island`;

CREATE TABLE `tiphunzire_island` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1 ROW_FORMAT=DYNAMIC;

/*Table structure for table `tiphunzire_item` */

DROP TABLE IF EXISTS `tiphunzire_item`;

CREATE TABLE `tiphunzire_item` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `status` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;

/*Table structure for table `tiphunzire_jobassignment` */

DROP TABLE IF EXISTS `tiphunzire_jobassignment`;

CREATE TABLE `tiphunzire_jobassignment` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` int DEFAULT NULL,
  `assignment_id` varchar(100) DEFAULT NULL,
  `reporting_id` int DEFAULT NULL,
  `dept_id` int DEFAULT NULL,
  `created` int DEFAULT NULL,
  `created_by` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

/*Table structure for table `tiphunzire_leave_list` */

DROP TABLE IF EXISTS `tiphunzire_leave_list`;

CREATE TABLE `tiphunzire_leave_list` (
  `id` int NOT NULL AUTO_INCREMENT,
  `leave_type` int DEFAULT NULL,
  `addStartDate` int DEFAULT NULL,
  `addEndDate` int DEFAULT NULL,
  `leave_teacher_id` int DEFAULT NULL,
  `adjust_teacher` int DEFAULT NULL,
  `teacher_list` varchar(50) DEFAULT NULL,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=61 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=DYNAMIC;

/*Table structure for table `tiphunzire_leavetype_list` */

DROP TABLE IF EXISTS `tiphunzire_leavetype_list`;

CREATE TABLE `tiphunzire_leavetype_list` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `days` int DEFAULT '0',
  `delete_status` int DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

/*Table structure for table `tiphunzire_loan` */

DROP TABLE IF EXISTS `tiphunzire_loan`;

CREATE TABLE `tiphunzire_loan` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` int DEFAULT NULL,
  `amount` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `description` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `delete_status` int DEFAULT NULL,
  `status` enum('pending','accepted','rejected','adjusted') DEFAULT NULL,
  `emi` int DEFAULT NULL,
  `paid_amount` varchar(50) DEFAULT NULL,
  `created_date` varchar(100) DEFAULT NULL,
  `updated_date` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=42 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=DYNAMIC;

/*Table structure for table `tiphunzire_over_time` */

DROP TABLE IF EXISTS `tiphunzire_over_time`;

CREATE TABLE `tiphunzire_over_time` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` int DEFAULT NULL,
  `hour` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `description` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `delete_status` int DEFAULT NULL,
  `status` enum('pending','accepted','rejected','adjusted') DEFAULT NULL,
  `created_date` varchar(100) DEFAULT NULL,
  `updated_date` varchar(100) DEFAULT NULL,
  `salary_id` int DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=DYNAMIC;

/*Table structure for table `tiphunzire_period` */

DROP TABLE IF EXISTS `tiphunzire_period`;

CREATE TABLE `tiphunzire_period` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `startdate` varchar(50) DEFAULT NULL,
  `enddate` varchar(50) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1 ROW_FORMAT=DYNAMIC;

/*Table structure for table `tiphunzire_permission` */

DROP TABLE IF EXISTS `tiphunzire_permission`;

CREATE TABLE `tiphunzire_permission` (
  `id` int NOT NULL AUTO_INCREMENT,
  `permission` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=82 DEFAULT CHARSET=latin1;

/*Table structure for table `tiphunzire_preveducation` */

DROP TABLE IF EXISTS `tiphunzire_preveducation`;

CREATE TABLE `tiphunzire_preveducation` (
  `id` int NOT NULL AUTO_INCREMENT,
  `school_name` varchar(50) DEFAULT NULL,
  `class` varchar(50) DEFAULT NULL,
  `marks` varchar(50) DEFAULT NULL,
  `sid` int DEFAULT NULL,
  `type` enum('admin','student') DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=92 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

/*Table structure for table `tiphunzire_registration` */

DROP TABLE IF EXISTS `tiphunzire_registration`;

CREATE TABLE `tiphunzire_registration` (
  `id` int NOT NULL AUTO_INCREMENT,
  `first_name` varchar(50) DEFAULT NULL,
  `middle_name` varchar(50) DEFAULT NULL,
  `last_name` varchar(50) DEFAULT NULL,
  `dob` varchar(50) DEFAULT NULL,
  `gender` varchar(50) DEFAULT NULL,
  `mobile` varchar(50) DEFAULT NULL,
  `email` varchar(50) DEFAULT NULL,
  `father_name` varchar(50) DEFAULT NULL,
  `mother_name` varchar(50) DEFAULT NULL,
  `address1` text,
  `address2` text,
  `zip_code` varchar(50) DEFAULT NULL,
  `state` varchar(50) DEFAULT NULL,
  `city` varchar(50) DEFAULT NULL,
  `country` varchar(50) DEFAULT NULL,
  `delete_status` varchar(50) DEFAULT NULL,
  `key_email` varchar(50) DEFAULT NULL,
  `status` varchar(50) DEFAULT NULL,
  `registration_status` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`),
  FULLTEXT KEY `first_name` (`first_name`,`email`)
) ENGINE=InnoDB AUTO_INCREMENT=111 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

/*Table structure for table `tiphunzire_retailer` */

DROP TABLE IF EXISTS `tiphunzire_retailer`;

CREATE TABLE `tiphunzire_retailer` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;

/*Table structure for table `tiphunzire_role` */

DROP TABLE IF EXISTS `tiphunzire_role`;

CREATE TABLE `tiphunzire_role` (
  `id` int NOT NULL AUTO_INCREMENT,
  `role` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=latin1;

/*Table structure for table `tiphunzire_role_permission` */

DROP TABLE IF EXISTS `tiphunzire_role_permission`;

CREATE TABLE `tiphunzire_role_permission` (
  `id` int NOT NULL AUTO_INCREMENT,
  `role` varchar(50) NOT NULL DEFAULT '0',
  `permission` varchar(50) NOT NULL DEFAULT '0',
  `status` varchar(50) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=107 DEFAULT CHARSET=latin1;

/*Table structure for table `tiphunzire_rolelist` */

DROP TABLE IF EXISTS `tiphunzire_rolelist`;

CREATE TABLE `tiphunzire_rolelist` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` varchar(20) DEFAULT NULL,
  `role_id` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=297 DEFAULT CHARSET=latin1;

/*Table structure for table `tiphunzire_salary` */

DROP TABLE IF EXISTS `tiphunzire_salary`;

CREATE TABLE `tiphunzire_salary` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` varchar(50) DEFAULT NULL,
  `fixed_salary` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `fixed_salary_val` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `fixed_tds_dropdwon` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `hra` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `basic_salary` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `travel` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `other_expenses` varchar(50) DEFAULT NULL,
  `tds_value` varchar(50) DEFAULT NULL,
  `tax` varchar(50) DEFAULT NULL,
  `pan_card` varchar(50) DEFAULT NULL,
  `account_number` varchar(50) DEFAULT NULL,
  `ifsc_code` varchar(50) DEFAULT NULL,
  `account_holder_name` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=DYNAMIC;

/*Table structure for table `tiphunzire_salary_month_wise` */

DROP TABLE IF EXISTS `tiphunzire_salary_month_wise`;

CREATE TABLE `tiphunzire_salary_month_wise` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `fixed_salary` int DEFAULT NULL,
  `fixed_salary_val` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `fixed_tds_dropdwon` int DEFAULT NULL,
  `hra` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `basic_salary` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `travel` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `other_expenses` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `tax` int DEFAULT NULL,
  `month` varchar(50) DEFAULT NULL,
  `year` varchar(50) DEFAULT NULL,
  `present_days` varchar(50) DEFAULT NULL,
  `working_days` varchar(50) DEFAULT NULL,
  `total` int DEFAULT NULL,
  `over_time_amount` varchar(50) DEFAULT NULL,
  `loan_amount` varchar(50) DEFAULT NULL,
  `advance_salary_amount` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=51 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=DYNAMIC;

/*Table structure for table `tiphunzire_sandy` */

DROP TABLE IF EXISTS `tiphunzire_sandy`;

CREATE TABLE `tiphunzire_sandy` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `password` varchar(50) DEFAULT NULL,
  `email` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

/*Table structure for table `tiphunzire_section_list` */

DROP TABLE IF EXISTS `tiphunzire_section_list`;

CREATE TABLE `tiphunzire_section_list` (
  `id` int NOT NULL AUTO_INCREMENT,
  `section_id` varchar(50) DEFAULT NULL,
  `class_id` varchar(50) DEFAULT NULL,
  `delete_status` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=381 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

/*Table structure for table `tiphunzire_session` */

DROP TABLE IF EXISTS `tiphunzire_session`;

CREATE TABLE `tiphunzire_session` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `startdate` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `enddate` varchar(50) DEFAULT NULL,
  `delete_status` varchar(50) DEFAULT NULL,
  `status` int DEFAULT NULL,
  `startMonth` varchar(50) DEFAULT NULL,
  `endMonth` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

/*Table structure for table `tiphunzire_sms_class` */

DROP TABLE IF EXISTS `tiphunzire_sms_class`;

CREATE TABLE `tiphunzire_sms_class` (
  `id` int NOT NULL AUTO_INCREMENT,
  `class` varchar(50) DEFAULT NULL,
  `no_of_period` int DEFAULT NULL,
  `period_duration` int DEFAULT NULL,
  `period_start_time` int DEFAULT NULL,
  `lunch_duration` int DEFAULT NULL,
  `lunch_start_time` int DEFAULT NULL,
  `delete_status` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

/*Table structure for table `tiphunzire_sms_period` */

DROP TABLE IF EXISTS `tiphunzire_sms_period`;

CREATE TABLE `tiphunzire_sms_period` (
  `id` int NOT NULL AUTO_INCREMENT,
  `period` varchar(50) DEFAULT NULL,
  `start_time` varchar(50) DEFAULT NULL,
  `end_time` varchar(50) DEFAULT NULL,
  `class_id` varchar(50) DEFAULT NULL,
  `class_list_id` varchar(50) DEFAULT NULL,
  `delete_status` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=37 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

/*Table structure for table `tiphunzire_student_marks` */

DROP TABLE IF EXISTS `tiphunzire_student_marks`;

CREATE TABLE `tiphunzire_student_marks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `student_id` varchar(50) NOT NULL DEFAULT '0',
  `session_id` varchar(50) NOT NULL DEFAULT '0',
  `exam_id` varchar(50) NOT NULL DEFAULT '0',
  `subject_id` varchar(50) NOT NULL DEFAULT '0',
  `subject_marks` varchar(50) NOT NULL DEFAULT '0',
  `total` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=78 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

/*Table structure for table `tiphunzire_student_order` */

DROP TABLE IF EXISTS `tiphunzire_student_order`;

CREATE TABLE `tiphunzire_student_order` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `status` varchar(10) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `order_id` int DEFAULT NULL,
  `location` enum('front','back') DEFAULT NULL,
  `field_name` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `show_name` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1 ROW_FORMAT=DYNAMIC;

/*Table structure for table `tiphunzire_student_subject` */

DROP TABLE IF EXISTS `tiphunzire_student_subject`;

CREATE TABLE `tiphunzire_student_subject` (
  `id` int NOT NULL AUTO_INCREMENT,
  `student_id` varchar(50) DEFAULT NULL,
  `subject_id` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=377 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

/*Table structure for table `tiphunzire_subject_list` */

DROP TABLE IF EXISTS `tiphunzire_subject_list`;

CREATE TABLE `tiphunzire_subject_list` (
  `id` int NOT NULL AUTO_INCREMENT,
  `teacher_id` varchar(50) DEFAULT NULL,
  `subject_id` varchar(50) DEFAULT NULL,
  `delete_status` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=323 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

/*Table structure for table `tiphunzire_supplier` */

DROP TABLE IF EXISTS `tiphunzire_supplier`;

CREATE TABLE `tiphunzire_supplier` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;

/*Table structure for table `tiphunzire_teacher_class_section_list` */

DROP TABLE IF EXISTS `tiphunzire_teacher_class_section_list`;

CREATE TABLE `tiphunzire_teacher_class_section_list` (
  `id` int NOT NULL AUTO_INCREMENT,
  `teacher_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `class_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `section_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=DYNAMIC;

/*Table structure for table `tiphunzire_teacher_list` */

DROP TABLE IF EXISTS `tiphunzire_teacher_list`;

CREATE TABLE `tiphunzire_teacher_list` (
  `id` int NOT NULL AUTO_INCREMENT,
  `teacher_id` varchar(255) DEFAULT NULL,
  `class_id` varchar(255) DEFAULT NULL,
  `delete_status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=623 DEFAULT CHARSET=latin1 ROW_FORMAT=DYNAMIC;

/*Table structure for table `tiphunzire_teacher_registration` */

DROP TABLE IF EXISTS `tiphunzire_teacher_registration`;

CREATE TABLE `tiphunzire_teacher_registration` (
  `id` int NOT NULL AUTO_INCREMENT,
  `first_name` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

/*Table structure for table `tiphunzire_temporary_timetable` */

DROP TABLE IF EXISTS `tiphunzire_temporary_timetable`;

CREATE TABLE `tiphunzire_temporary_timetable` (
  `id` int NOT NULL AUTO_INCREMENT,
  `timetable_id` int DEFAULT NULL,
  `period_id` int DEFAULT NULL,
  `week_id` int DEFAULT NULL,
  `teacher_id` int DEFAULT NULL,
  `class_id` int DEFAULT NULL,
  `section_id` int DEFAULT NULL,
  `subject_id` int DEFAULT NULL,
  `start_time` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `end_time` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `leaveList_id` int DEFAULT NULL,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=DYNAMIC;

/*Table structure for table `tiphunzire_temporary_timetable_history` */

DROP TABLE IF EXISTS `tiphunzire_temporary_timetable_history`;

CREATE TABLE `tiphunzire_temporary_timetable_history` (
  `id` int NOT NULL AUTO_INCREMENT,
  `timetable_id` int DEFAULT NULL,
  `period_id` int DEFAULT NULL,
  `week_id` int DEFAULT NULL,
  `teacher_id` int DEFAULT NULL,
  `class_id` int DEFAULT NULL,
  `section_id` int DEFAULT NULL,
  `subject_id` int DEFAULT NULL,
  `start_time` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `end_time` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `leaveList_id` int DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=DYNAMIC;

/*Table structure for table `tiphunzire_tenant` */

DROP TABLE IF EXISTS `tiphunzire_tenant`;

CREATE TABLE `tiphunzire_tenant` (
  `id` int NOT NULL AUTO_INCREMENT,
  `tenant_name` varchar(20) DEFAULT NULL,
  `user_name` varchar(50) DEFAULT NULL,
  `password` varchar(50) DEFAULT NULL,
  `delete_status` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

/*Table structure for table `tiphunzire_timetable` */

DROP TABLE IF EXISTS `tiphunzire_timetable`;

CREATE TABLE `tiphunzire_timetable` (
  `id` int NOT NULL AUTO_INCREMENT,
  `period_id` int DEFAULT NULL,
  `week_id` int DEFAULT NULL,
  `teacher_id` int DEFAULT NULL,
  `class_id` int DEFAULT NULL,
  `section_id` int DEFAULT NULL,
  `subject_id` int DEFAULT NULL,
  `start_time` int DEFAULT NULL,
  `end_time` int DEFAULT NULL,
  `adjustment` int DEFAULT NULL,
  `custom_table_id` int DEFAULT NULL,
  `adjusted_lecture` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=73 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

/*Table structure for table `tiphunzire_upload_document` */

DROP TABLE IF EXISTS `tiphunzire_upload_document`;

CREATE TABLE `tiphunzire_upload_document` (
  `id` int NOT NULL AUTO_INCREMENT,
  `color_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `logo_name` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `logo_path` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `favicon_name` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `favicon_path` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `water_mark_name` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `water_mark_path` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `working_hour` int DEFAULT NULL,
  `file_size` int DEFAULT NULL,
  `No_of_files` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

/*Table structure for table `tiphunzire_uploadimage` */

DROP TABLE IF EXISTS `tiphunzire_uploadimage`;

CREATE TABLE `tiphunzire_uploadimage` (
  `id` int NOT NULL AUTO_INCREMENT,
  `file_name` varchar(50) DEFAULT NULL,
  `file_path` varchar(50) DEFAULT NULL,
  `file_real_name` varchar(50) DEFAULT NULL,
  `document_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `std_id` varchar(50) DEFAULT NULL,
  `document_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `type` enum('photo','document') CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `delete_status` int DEFAULT NULL,
  `uploadby` enum('admin','student') DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=57 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

/*Table structure for table `tiphunzire_user_attendance` */

DROP TABLE IF EXISTS `tiphunzire_user_attendance`;

CREATE TABLE `tiphunzire_user_attendance` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `date` varchar(255) DEFAULT NULL,
  `attendance_status` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `role_id` int DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=283 DEFAULT CHARSET=latin1 ROW_FORMAT=DYNAMIC;

/*Table structure for table `tiphunzire_user_permission` */

DROP TABLE IF EXISTS `tiphunzire_user_permission`;

CREATE TABLE `tiphunzire_user_permission` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT '0',
  `permission_id` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT '0',
  `status` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1393 DEFAULT CHARSET=latin1 ROW_FORMAT=DYNAMIC;

/*Table structure for table `tiphunzire_users` */

DROP TABLE IF EXISTS `tiphunzire_users`;

CREATE TABLE `tiphunzire_users` (
  `id` int NOT NULL AUTO_INCREMENT,
  `uname` varchar(255) DEFAULT NULL,
  `firstname` varchar(255) NOT NULL,
  `lastname` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `password` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `subject_name` varchar(255) NOT NULL,
  `std_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  FULLTEXT KEY `firstname` (`firstname`,`email`)
) ENGINE=InnoDB AUTO_INCREMENT=141 DEFAULT CHARSET=latin1;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;
insert  into `tiphunzire_attendance_type`(`id`,`name`,`status`,`delete_status`) values 
(1,'present','1','0'),
(2,'absent','1','0'),
(3,'leave','1','0'),
(4,'summer vacation','1','0'),
(5,'winter vacation','1','1'),
(6,'boot camp','1','1'),
(7,'bio-metric','1','1'),
(8,'shd','1','1'),
(9,'bio-metric','1','0'),
(10,'present','1','1'),
(11,'present','1','1'),
(12,'','1','1'),
(13,',m.','1','1'),
(14,'abc','1','1'),
(15,'bn','1','1');

/*Data for the table `tiphunzire_leavetype_list` */

insert  into `tiphunzire_leavetype_list`(`id`,`name`,`days`,`delete_status`) values 
(19,'SL',5,0),
(20,'EL',2,0),
(21,'CL',7,0),
(22,'we',3,1);

/*Data for the table `tiphunzire_role` */

insert  into `tiphunzire_role`(`id`,`role`) values 
(5,'admin'),
(12,'student'),
(20,'reporting officer'),
(22,'principal'),
(24,'guest teacher'),
(25,'manager'),
(29,'class teacher'),
(58,'teacher'),
(59,'staff'),
(88,'rplq');

/*Data for the table `tiphunzire_rolelist` */

insert  into `tiphunzire_rolelist`(`id`,`user_id`,`role_id`) values 

(253,'119','5');

insert  into `tiphunzire_users`(`id`,`uname`,`firstname`,`lastname`,`email`,`password`,`status`,`subject_name`,`std_id`) values 
(119,'admin','admin','admin','admin','ab233b682ec355648e7891e66c54191b','1','1',NULL);
insert  into `tiphunzire_users`(`id`,`uname`,`firstname`,`lastname`,`email`,`password`,`status`,`subject_name`,`std_id`) values 
(2,'tiphunzire','Tenant','admin','admin@admin.com','500120aec59d2886706bd8f6572bb333','1','test','1');